package tests;

import static org.junit.Assert.*;

import org.junit.Test;

/* Remember we need to import our classes */
/* that are in a different package        */
import computerSys.*;

/* Following statements allow tests to be run in alphabetical order */
import org.junit.FixMethodOrder;
import org.junit.runners.MethodSorters;
@FixMethodOrder(MethodSorters.NAME_ASCENDING)

public class StudentTests {

	/* Intentionally we write the tests using names that are not    */
	/* sorted. You will see them sorted when you run the JUnit test */
	@Test
	public void test2() {
		Mouse m1 = new Mouse("Dell");
		assertEquals(m1.toString(), "Dell, 0, 0");
	}

	@Test
	public void test1() {
		Computer computer = new Computer("IBM", "IBMMouse");	
		assertEquals(computer.toString(), "IBM, IBMMouse, 0, 0");
	}
	
	/* Illustrates how to check a method throws a particular exception */
	@Test(expected = IllegalArgumentException.class)
	public void test3() {
		new Mouse(null);
	}
}
