package examples;

import java.util.*; /* Needed so we can use ArrayList */

public class Driver1 {

	public static void main(String[] args) {
		Tetris tetris1 = new Tetris(10);
		Blackjack blackjack1 = new Blackjack(52);
		Tetris tetris2 = new Tetris(20);

		ArrayList<Game> games = new ArrayList<Game>();
		games.add(tetris1);
		games.add(blackjack1);
		games.add(tetris2);

		/*
		 * The ArrayList class provides an iterator. An iterator allow us to go over all
		 * the elements of a collection (e.g., an ArrayList, a set) by using methods
		 * hasNext() and next(). The hasNext() method returns true if there is an
		 * element available to be processed. The next() method returns the reference.
		 * The protocol to use an iterator is to call hasNext() first, then next() if
		 * there is an element. There is a remove() method associated with an iterator,
		 * but we will not discuss it here (you are not responsible for it).
		 */

		/*
		 * Retrieves an iterator for the ArrayList. The Iterator type is Iterator<> and
		 * in between <> you place the kind of elements associated with the ArrayList.
		 */
		Iterator<Game> iter = games.iterator();
		while (iter.hasNext()) {
			Game game = iter.next(); // Retrieving reference to next Game

			// Some processing (in this case printing)
			System.out.println(game);
		}

		System.out.println("\n\nSecond Iteration");
		Iterator<Game> iter2 = games.iterator();
		/*
		 * Calling hasNext() several times does not change what is considered to be the
		 * next element. It just returns whether there is an element to retrieve.
		 */
		iter2.hasNext();
		iter2.hasNext();
		iter2.hasNext();
		while (iter2.hasNext()) {
			Game game = iter2.next(); // Retrieving reference to next Game

			// Some processing (in this case printing)
			System.out.println(game);
		}

		/*
		 * Any class that provides an Iterator can be used with a for loop alternative
		 * called the for-each or enhanced for loop. Behind the scenes the for-each
		 * relies on an Iterator. If you have an ArrayList, you can go over the element
		 * using a for-each
		 */

		System.out.println("\n\nUsing a for-each");
		for (Game oneGame : games) {
			// Some processing
			System.out.println(oneGame);

			if (oneGame instanceof Tetris) {
				Tetris tetris = (Tetris) oneGame;
				tetris.rotateOnce();
			}
		}

		/*
		 * When you need to print an ArrayList you don't need to loop. The ArrayList
		 * toString() method generates a string for every entry of the ArrayList.
		 */
		System.out.println("\n\nUsing ArrayList toString():\n" + games);

		
	}
}
