package examples;

import java.util.*;

public class Driver2 {

	/*
	 * This recursive method returns a string where every instance of 'a' (if any)
	 * has been replaced with 'A'.
	 */
	public static String letterToUppercase(String str) {
		if (str.isEmpty()) { // Base case (we could have used str.length() == 1). There are
			return "";       // no characters in an empty string, therefore nothing to do
		} else if (str.charAt(0) == 'a') {
			/*
			 * We will replace 'a' with 'A' and then we need to do the same in the remainder
			 * of the string. How can we get the remainder? By using the substring() method.
			 * The substring() method takes a value representing the position (index) in the
			 * string that marks the beginning of the string to return.
			 * 
			 * Now that we have the reminder, how can we replace instances of 'a' with 'A'?
			 * Do we have a method that performs such a task? Well, we are writing it, but
			 * we are not done. Here is the leap of faith you have to make: even though you
			 * have not finished implementing the method, you will assume you have finished
			 * it and it is working!
			 */

			return 'A' + letterToUppercase(str.substring(1));
		} else {
			/*
			 * If the current character is other than 'A' we don't need to change it; still
			 * we need to include it in the string that will be eventually returned.
			 */
			return str.charAt(0) + letterToUppercase(str.substring(1));
		}
	}

	public static void main(String[] args) {
		String str = "Dreammaker";

		System.out.println("Original: " + str);
		System.out.println("Processed: " + letterToUppercase(str));
	}
}
