package examples;

import java.util.Arrays;

public class Driver3 {
	/*
	 * This method will be a recursive method that increases each entry of the array
	 * by one. Unfortunately, in this case, solving the problem cannot be completed
	 * by having the method call itself. You may be able to do it by adding some
	 * instance variables, but we want the method to not rely on any instance /
	 * static variables. In this case, we can satisfy the recursive requirement by
	 * defining a method (commonly referred to as the auxiliary) that is called by
	 * the original one. The auxiliary is the one that is recursive.
	 */
	public static void increaseByOne(int[] array) {
		increaseByOne(array, 0);
	}

	/*
	 * Can we use the same method name for the auxiliary? Yes, thanks to method
	 * overloading. Remember that in method overloading two methods have the same
	 * name, but different parameters. Typical example of overloading are
	 * constructors for a class. The index parameter represents where we will start
	 * processing the array. Initially we will start at zero and every call will
	 * increase by one.
	 */
	public static void increaseByOne(int[] array, int index) {
		/* The base case stops the recursion and it does not call the method again */
		if (index > array.length - 1) { // We don't have more array to process
			return; // We just return
		} else {
			/* Processing entry associated with index */
			array[index]++;

			/*
			 * We need to increase the remainder of the array. Do we have a method that
			 * performs such a task? Well, we are writing it, but we are not done. Here is
			 * the leap of faith you have to make: even though you have not finished
			 * implementing the method, you will assume you have finished it and it is
			 * working!
			 */

			/*
			 * Recursive call that says: "Now process the remainder of the array". After
			 * running this example, see what happens when you use index++ instead of
			 * index + 1. Why index++ fails? index++ says at some point in the future index
			 * will be increased, but it is not happening now. The recursive call does not
			 * receive the increased value. The bottom line is: do not use ++ or -- in
			 * arguments of method calls (not just recursive).
			 */
			increaseByOne(array, index + 1);
		}
	}

	public static void main(String[] args) {
		int[] array = { 10, 11, 12, 23, 24 };

		System.out.println("Original: " + Arrays.toString(array));
		increaseByOne(array);
		System.out.println("Increased: " + Arrays.toString(array));
	}
	
	
}
