/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldcanvas;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import javalib.worldimages.OutlineMode;
import javalib.worldimages.RectangleImage;
import javalib.worldimages.WorldImage;

public abstract class WorldSceneBase {
    public int width;
    public int height;
    protected IList<PlaceImage> imgs;
    protected Deque<PlaceImage> revImgs;

    protected WorldSceneBase(int width, int height) {
        this.width = width;
        this.height = height;
        this.imgs = new Empty<PlaceImage>();
        this.imgs = this.imgs.add(new PlaceImage(new RectangleImage(width, height, OutlineMode.OUTLINE, Color.black), width / 2, height / 2));
        this.revImgs = null;
    }

    protected WorldSceneBase(int width, int height, IList<PlaceImage> imgs) {
        this.width = width;
        this.height = height;
        this.imgs = imgs;
        this.revImgs = null;
    }

    protected void draw(Graphics2D g) {
        this.revImagesIfNeeded();
        for (PlaceImage i : this.revImgs) {
            g.translate(i.x - i.img.pinhole.x, i.y - i.img.pinhole.y);
            i.img.draw(g);
            g.translate(-i.x + i.img.pinhole.x, -i.y + i.img.pinhole.y);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldSceneBase)) {
            return false;
        }
        WorldSceneBase other = (WorldSceneBase)obj;
        if (this.width != other.width || this.height != other.height) {
            return false;
        }
        if (this.width == 0 || this.height == 0) {
            return true;
        }
        BufferedImage image1 = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics2D1 = image1.createGraphics();
        this.draw(graphics2D1);
        BufferedImage image2 = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics2D2 = image2.createGraphics();
        other.draw(graphics2D2);
        int[] pix1 = new int[this.width * this.height];
        int[] pix2 = new int[this.width * this.height];
        PixelGrabber pg1 = new PixelGrabber(image1, 0, 0, this.width, this.height, pix1, 0, this.width);
        PixelGrabber pg2 = new PixelGrabber(image2, 0, 0, this.width, this.height, pix2, 0, this.width);
        try {
            pg1.grabPixels();
            pg2.grabPixels();
            return Arrays.equals(pix1, pix2);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private void revImagesIfNeeded() {
        if (this.revImgs == null) {
            this.revImgs = new ArrayDeque<PlaceImage>();
            for (PlaceImage i : this.imgs) {
                this.revImgs.push(i);
            }
        }
    }

    public StringBuilder toIndentedString(StringBuilder sb, String linePrefix, int indent) {
        this.revImagesIfNeeded();
        sb.append("new ").append(this.getClass().getSimpleName()).append("(){").append("this.width = ").append(this.width).append(", ").append("this.height = ").append(this.height);
        int count = 0;
        for (PlaceImage i : this.revImgs) {
            sb.append(",\n").append(linePrefix + "  ").append("[").append(count).append("] = PlaceImage(");
            i.toIndentedString(sb, linePrefix + "    ", indent);
            sb.append(")");
            ++count;
        }
        sb.append("\n").append(linePrefix).append("}");
        return sb;
    }

    protected class PlaceImage {
        WorldImage img;
        int x;
        int y;

        public PlaceImage(WorldImage i, int x, int y) {
            this.img = i;
            this.x = x;
            this.y = y;
        }

        StringBuilder toIndentedString(StringBuilder sb, String linePrefix, int indent) {
            sb.append("this.x = ").append(this.x).append(", ");
            sb.append("this.y = ").append(this.y).append(",\n");
            sb.append(linePrefix);
            return this.img.toIndentedString(sb, linePrefix + "  ", indent);
        }
    }

    protected class IListIterator<T>
    implements Iterator<T> {
        IList<T> source;

        IListIterator(IList<T> source) {
            this.source = source;
        }

        @Override
        public boolean hasNext() {
            return this.source instanceof Cons;
        }

        @Override
        public T next() {
            Cons s = (Cons)this.source;
            this.source = s.rest;
            return s.first;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }

    protected class Cons<T>
    implements IList<T> {
        T first;
        IList<T> rest;

        Cons(T first, IList<T> rest) {
            this.first = first;
            this.rest = rest;
        }

        @Override
        public Cons<T> add(T val) {
            return new Cons<T>(val, this);
        }

        @Override
        public Iterator<T> iterator() {
            return new IListIterator(this);
        }
    }

    protected class Empty<T>
    implements IList<T> {
        protected Empty() {
        }

        @Override
        public Cons<T> add(T val) {
            return new Cons<T>(val, this);
        }

        @Override
        public Iterator<T> iterator() {
            return new IListIterator(this);
        }
    }

    protected static interface IList<T>
    extends Iterable<T> {
        public Cons<T> add(T var1);
    }
}

