/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Stack;
import javalib.worldimages.BoundingBox;
import javalib.worldimages.FieldsWLItem;
import javalib.worldimages.ImageField;
import javalib.worldimages.ImageMaker;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public final class FromFileImage
extends WorldImage {
    public String fileName;
    protected volatile ImageMaker imread;

    public FromFileImage(String fileName) {
        super(1);
        this.imread = new ImageMaker(fileName);
        this.fileName = fileName;
    }

    @Override
    int numKids() {
        return 0;
    }

    @Override
    WorldImage getKid(int i) {
        throw new IllegalArgumentException("No such kid " + i);
    }

    @Override
    AffineTransform getTransform(int i) {
        throw new IllegalArgumentException("No such kid " + i);
    }

    @Override
    protected void drawStackUnsafe(Graphics2D g) {
        g.translate(-((double)this.imread.width / 2.0), -((double)this.imread.height / 2.0));
        g.drawRenderedImage(this.imread.image, new AffineTransform());
        g.translate((double)this.imread.width / 2.0, (double)this.imread.height / 2.0);
    }

    @Override
    protected void drawStacksafe(Graphics2D g, Stack<WorldImage> images, Stack<AffineTransform> txs) {
        this.drawStackUnsafe(g);
    }

    @Override
    public double getWidth() {
        return this.imread.width;
    }

    @Override
    public double getHeight() {
        return this.imread.height;
    }

    @Override
    protected BoundingBox getBBHelp(AffineTransform t) {
        double w = this.getWidth();
        double h = this.getHeight();
        Point2D tl = t.transform(new Point2D.Double(-w / 2.0, -h / 2.0), null);
        Point2D br = t.transform(new Point2D.Double(w / 2.0, h / 2.0), null);
        return new BoundingBox(tl.getX(), tl.getY(), br.getX(), br.getY());
    }

    @Override
    protected StringBuilder toIndentedStringHelp(StringBuilder sb, Stack<Object> stack) {
        sb = sb.append("new ").append(this.simpleName()).append("(").append("this.fileName = \"").append(this.fileName.replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
        if (this.pinhole.x != 0 || this.pinhole.y != 0) {
            stack.push(new FieldsWLItem(this.pinhole, new ImageField[0]));
        } else {
            sb = sb.append(")");
        }
        return sb;
    }

    @Override
    protected boolean equalsStacksafe(WorldImage other, Stack<WorldImage> worklistThis, Stack<WorldImage> worklistThat) {
        if (other instanceof FromFileImage) {
            FromFileImage that = (FromFileImage)other;
            return this.fileName.equals(that.fileName) && this.pinhole.equals(that.pinhole);
        }
        return false;
    }

    public int hashCode() {
        return this.fileName.hashCode();
    }

    @Override
    public WorldImage movePinholeTo(Posn p) {
        FromFileImage i = new FromFileImage(this.fileName);
        i.pinhole = p;
        return i;
    }
}

