/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.Stack;
import javalib.worldimages.BoundingBox;
import javalib.worldimages.DPosn;
import javalib.worldimages.FieldsWLItem;
import javalib.worldimages.ImageField;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public final class LineImage
extends WorldImage {
    public Posn endPoint;
    public Color color;

    public LineImage(Posn endPoint, Color color) {
        super(1);
        this.endPoint = endPoint;
        this.color = color;
    }

    @Override
    int numKids() {
        return 0;
    }

    @Override
    WorldImage getKid(int i) {
        throw new IllegalArgumentException("No such kid " + i);
    }

    @Override
    AffineTransform getTransform(int i) {
        throw new IllegalArgumentException("No such kid " + i);
    }

    @Override
    protected BoundingBox getBBHelp(AffineTransform t) {
        Point2D end1 = WorldImage.transformPosn(t, (double)(-this.endPoint.x) / 2.0, (double)(-this.endPoint.y) / 2.0);
        Point2D end2 = WorldImage.transformPosn(t, (double)this.endPoint.x / 2.0, (double)this.endPoint.y / 2.0);
        return new BoundingBox(end1, end2);
    }

    @Override
    protected void drawStackUnsafe(Graphics2D g) {
        if (this.color == null) {
            this.color = new Color(0, 0, 0);
        }
        DPosn midpoint = new DPosn((double)this.endPoint.x / 2.0, (double)this.endPoint.y / 2.0);
        Paint oldPaint = g.getPaint();
        g.setPaint(this.color);
        g.draw(new Line2D.Double(-midpoint.x, -midpoint.y, midpoint.x, midpoint.y));
        g.setPaint(oldPaint);
    }

    @Override
    protected void drawStacksafe(Graphics2D g, Stack<WorldImage> images, Stack<AffineTransform> txs) {
        this.drawStackUnsafe(g);
    }

    @Override
    public double getWidth() {
        return Math.abs(this.endPoint.x);
    }

    @Override
    public double getHeight() {
        return Math.abs(this.endPoint.y);
    }

    @Override
    protected StringBuilder toIndentedStringHelp(StringBuilder sb, Stack<Object> stack) {
        sb = sb.append("new ").append(this.simpleName()).append("(").append("this.endPoint = ").append(this.endPoint.coords()).append(",");
        stack.push(new FieldsWLItem(this.pinhole, new ImageField("color", this.color)));
        return sb;
    }

    @Override
    protected boolean equalsStacksafe(WorldImage other, Stack<WorldImage> worklistThis, Stack<WorldImage> worklistThat) {
        if (other instanceof LineImage) {
            LineImage that = (LineImage)other;
            return this.endPoint.x == that.endPoint.x && this.endPoint.y == that.endPoint.y && this.color.equals(that.color) && this.pinhole.equals(that.pinhole);
        }
        return false;
    }

    public int hashCode() {
        return this.color.hashCode() + this.endPoint.x + this.endPoint.y;
    }

    @Override
    public WorldImage movePinholeTo(Posn p) {
        LineImage i = new LineImage(this.endPoint, this.color);
        i.pinhole = p;
        return i;
    }
}

