/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import tester.ISame;
import tester.Reflector;
import tester.Traversal;

public class Inspector {
    protected static double TOLERANCE = 0.001;
    protected static String INDENT = "  ";
    private HashMap<Integer, Integer> hashmap = new HashMap();
    protected static boolean INEXACT_COMPARED = false;
    protected static boolean INEXACT_ALLOWED = false;

    protected boolean inexactViolation() {
        return INEXACT_COMPARED && !INEXACT_ALLOWED;
    }

    public <T> boolean isSame(T obj1, T obj2) {
        this.hashmap.clear();
        INEXACT_COMPARED = false;
        return this.isSamePrivate(obj1, obj2);
    }

    protected boolean inexactTest(double tolerance) {
        INEXACT_COMPARED = false;
        INEXACT_ALLOWED = true;
        TOLERANCE = tolerance;
        return tolerance < 0.0;
    }

    protected boolean exactTest() {
        INEXACT_COMPARED = false;
        INEXACT_ALLOWED = false;
        return true;
    }

    public <T> boolean isSameIterable(Iterable<T> obj1, Iterable<T> obj2) {
        this.hashmap.clear();
        INEXACT_ALLOWED = false;
        INEXACT_COMPARED = false;
        return this.isSamePrivate(obj1, obj2);
    }

    public <T> boolean isSameSet(Set<T> obj1, Set<T> obj2) {
        this.hashmap.clear();
        INEXACT_ALLOWED = false;
        INEXACT_COMPARED = false;
        return this.isSamePrivate(obj1, obj2);
    }

    public <T> boolean isSameTraversal(Traversal<T> obj1, Traversal<T> obj2) {
        this.hashmap.clear();
        INEXACT_ALLOWED = false;
        INEXACT_COMPARED = false;
        return this.isSamePrivate(obj1, obj2);
    }

    private boolean isSamePrivate(Object obj1, Object obj2) {
        Stack<Object> lefts = new Stack<Object>();
        Stack<Object> rights = new Stack<Object>();
        lefts.push(obj1);
        rights.push(obj2);
        while (!lefts.empty()) {
            WLItem right;
            WLItem left;
            obj1 = lefts.peek();
            obj2 = rights.peek();
            if (obj1 == null && obj2 == null) {
                lefts.pop();
                rights.pop();
                continue;
            }
            if (obj1 == null || obj2 == null) {
                return false;
            }
            Class<?> klass1 = obj1.getClass();
            Class<?> klass2 = obj2.getClass();
            if (klass1.equals(String.class)) {
                if (obj1.equals(obj2)) {
                    lefts.pop();
                    rights.pop();
                    continue;
                }
                return false;
            }
            if (klass1.isPrimitive() || Inspector.isWrapperClass(klass1.getName())) {
                if (this.isDouble(klass1.getName())) {
                    if (this.isSameDouble((Double)obj1, (Double)obj2)) {
                        lefts.pop();
                        rights.pop();
                        continue;
                    }
                    return false;
                }
                if (this.isFloat(klass1.getName())) {
                    if (this.isSameDouble(((Float)obj1).floatValue(), ((Float)obj2).floatValue())) {
                        lefts.pop();
                        rights.pop();
                        continue;
                    }
                    return false;
                }
                if (obj1.equals(obj2)) {
                    lefts.pop();
                    rights.pop();
                    continue;
                }
                return false;
            }
            String obj1Name = klass1.getName();
            if (Inspector.isOurCanvas(obj1Name)) {
                return obj1.equals(obj2);
            }
            if (Inspector.isWorldImage(klass1)) {
                return obj1.equals(obj2);
            }
            if (!(obj1 instanceof WLItem) && !(obj2 instanceof WLItem)) {
                Integer i1 = System.identityHashCode(obj1);
                Integer i2 = System.identityHashCode(obj2);
                Integer i2match = this.hashmap.get(i1 * i1 + i2 * i2);
                if (i2match != null && i2match.equals(i1 + i2)) {
                    lefts.pop();
                    rights.pop();
                    continue;
                }
                this.hashmap.put(i1 * i1 + i2 * i2, i1 + i2);
            }
            if (obj1.getClass().isArray() && obj2.getClass().isArray() && obj1.getClass() == obj2.getClass()) {
                if (Array.getLength(obj1) != Array.getLength(obj2)) {
                    return false;
                }
                lefts.pop();
                rights.pop();
                lefts.push(new ArrayWLItem((Object[])obj1));
                rights.push(new ArrayWLItem((Object[])obj2));
                continue;
            }
            if (obj1 instanceof ISame && obj2 instanceof ISame) {
                if (((ISame)obj1).same((ISame)obj2)) {
                    lefts.pop();
                    rights.pop();
                    continue;
                }
                return false;
            }
            if (obj1 instanceof Set && obj2 instanceof Set && obj1.getClass().getName().startsWith("java.util")) {
                if (((Set)obj1).size() != ((Set)obj2).size()) {
                    return false;
                }
                for (Object item1 : (Set)obj1) {
                    boolean match = false;
                    for (Object item2 : (Set)obj2) {
                        if (!item1.equals(item2)) continue;
                        match = true;
                    }
                    if (match) continue;
                    return false;
                }
                lefts.pop();
                rights.pop();
                continue;
            }
            if (obj1 instanceof Iterable && obj2 instanceof Iterable && obj1.getClass().getName().startsWith("java.util")) {
                lefts.pop();
                rights.pop();
                lefts.push(new IteratorWLItem(((Iterable)obj1).iterator()));
                rights.push(new IteratorWLItem(((Iterable)obj2).iterator()));
                continue;
            }
            if (obj1 instanceof Traversal && obj2 instanceof Traversal) {
                Traversal tr1 = (Traversal)obj1;
                Traversal tr2 = (Traversal)obj2;
                if (tr1.isEmpty() && tr2.isEmpty()) {
                    lefts.pop();
                    rights.pop();
                    continue;
                }
                if (tr1.isEmpty() || tr2.isEmpty()) {
                    return false;
                }
                lefts.pop();
                rights.pop();
                Object left2 = tr1.getFirst();
                Object right2 = tr2.getFirst();
                lefts.push(tr1.getRest());
                lefts.push(left2);
                rights.push(tr2.getRest());
                rights.push(right2);
                continue;
            }
            if (obj1 instanceof Map && obj2 instanceof Map && obj1.getClass().getName().startsWith("java.util")) {
                if (((Map)obj1).size() != ((Map)obj2).size()) {
                    return false;
                }
                lefts.pop();
                rights.pop();
                lefts.push(new MapWLItem((Map)obj1));
                rights.push(new MapWLItem((Map)obj2));
                continue;
            }
            if (obj1 instanceof ArrayWLItem && obj2 instanceof ArrayWLItem) {
                left = (ArrayWLItem)obj1;
                right = (ArrayWLItem)obj2;
                if (((ArrayWLItem)left).hasNext() && ((ArrayWLItem)right).hasNext()) {
                    lefts.push(((ArrayWLItem)left).next());
                    rights.push(((ArrayWLItem)right).next());
                    continue;
                }
                lefts.pop();
                rights.pop();
                continue;
            }
            if (obj1 instanceof IteratorWLItem && obj2 instanceof IteratorWLItem) {
                left = (IteratorWLItem)obj1;
                right = (IteratorWLItem)obj2;
                if (((IteratorWLItem)left).hasNext() && ((IteratorWLItem)right).hasNext()) {
                    lefts.push(((IteratorWLItem)left).next());
                    rights.push(((IteratorWLItem)right).next());
                    continue;
                }
                if (((IteratorWLItem)left).hasNext() || ((IteratorWLItem)right).hasNext()) {
                    return false;
                }
                lefts.pop();
                rights.pop();
                continue;
            }
            if (obj1 instanceof MapWLItem && obj2 instanceof MapWLItem) {
                left = (MapWLItem)obj1;
                right = (MapWLItem)obj2;
                if (((MapWLItem)left).hasNext()) {
                    Object key = ((MapWLItem)left).next();
                    if (!((MapWLItem)right).src.containsKey(key)) {
                        return false;
                    }
                    lefts.push(((MapWLItem)left).src.get(key));
                    rights.push(((MapWLItem)right).src.get(key));
                    continue;
                }
                lefts.pop();
                rights.pop();
                continue;
            }
            if (obj1 instanceof FieldsWLItem && obj2 instanceof FieldsWLItem) {
                left = (FieldsWLItem)obj1;
                right = (FieldsWLItem)obj2;
                if (((FieldsWLItem)left).hasNext() && ((FieldsWLItem)right).hasNext()) {
                    Field f1 = ((FieldsWLItem)left).next();
                    Field f2 = ((FieldsWLItem)right).next();
                    try {
                        lefts.push(f1.get(((FieldsWLItem)left).obj));
                        rights.push(f2.get(((FieldsWLItem)right).obj));
                    }
                    catch (IllegalAccessException e) {
                        System.out.println("same comparing " + f1.getType().getName() + " and " + f2.getType().getName() + "cannot access the field " + ((FieldsWLItem)left).cur + " message: " + e.getMessage());
                        System.out.println("class 1: " + ((FieldsWLItem)left).obj.getClass().getName());
                        System.out.println("class 2: " + ((FieldsWLItem)right).obj.getClass().getName());
                    }
                    continue;
                }
                if (((FieldsWLItem)left).hasNext() || ((FieldsWLItem)right).hasNext()) {
                    return false;
                }
                lefts.pop();
                rights.pop();
                continue;
            }
            if (!klass1.equals(klass2)) {
                return false;
            }
            Reflector r1 = new Reflector(obj1);
            Reflector r2 = new Reflector(obj2);
            lefts.pop();
            rights.pop();
            lefts.push(new FieldsWLItem(obj1, r1.sampleDeclaredFields));
            rights.push(new FieldsWLItem(obj2, r2.sampleDeclaredFields));
        }
        return true;
    }

    protected boolean isSameDouble(double d1, double d2) {
        if (d1 - d2 == 0.0) {
            return true;
        }
        INEXACT_COMPARED = true;
        if (d1 == 0.0) {
            return Math.abs(d2) < TOLERANCE;
        }
        if (d2 == 0.0) {
            return Math.abs(d1) < TOLERANCE;
        }
        return Math.abs(d1 - d2) / Math.abs((d1 + d2) / 2.0) < TOLERANCE;
    }

    protected boolean isDouble(String name) {
        return name.equals("double") || name.equals("java.lang.Double");
    }

    protected boolean isFloat(String name) {
        return name.equals("float") || name.equals("java.lang.Float");
    }

    protected static boolean isWrapperClass(String name) {
        return name.equals("java.lang.Integer") || name.equals("java.lang.Long") || name.equals("java.lang.Short") || name.equals("java.math.BigInteger") || name.equals("java.math.BigDecimal") || name.equals("java.lang.Float") || name.equals("java.lang.Double") || name.equals("java.lang.Byte") || name.equals("java.lang.Boolean") || name.equals("java.lang.Character");
    }

    protected static boolean isOurCanvas(String name) {
        return name.equals("draw.Canvas") || name.equals("idraw.Canvas") || name.equals("adraw.Canvas") || name.equals("funworld.Canvas") || name.equals("impworld.Canvas") || name.equals("appletworld.Canvas") || name.equals("javalib.worldcanvas.CanvasPanel") || name.equals("javalib.worldcanvas.WorldCanvas") || name.equals("javalib.worldcanvas.WorldSceneBase") || name.equals("javalib.funworld.WorldScene") || name.equals("javalib.impworld.WorldScene") || name.equals("impsoundworld.Canvas") || name.equals("appletsoundworld.Canvas");
    }

    protected static boolean isWorldImage(Class<?> c) {
        Package p = c.getPackage();
        return p != null && p.getName().startsWith("javalib.worldimages");
    }

    private static class FieldsWLItem
    implements Iterator<Field>,
    WLItem {
        Object obj;
        Field[] fields;
        int cur;

        FieldsWLItem(Object obj, Field[] fields) {
            this.obj = obj;
            this.fields = fields;
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.fields.length;
        }

        @Override
        public Field next() {
            return this.fields[this.cur++];
        }

        @Override
        public void remove() {
        }
    }

    private static class MapWLItem
    implements Iterator<Object>,
    WLItem {
        Map<Object, Object> src;
        Iterator<Object> keys;

        MapWLItem(Map<Object, Object> src) {
            this.src = src;
            this.keys = src.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Object next() {
            return this.keys.next();
        }

        @Override
        public void remove() {
        }
    }

    private static class IteratorWLItem<T>
    implements Iterator<T>,
    WLItem {
        Iterator<T> iter;
        int cur;

        IteratorWLItem(Iterator<T> iter) {
            this.iter = iter;
            this.cur = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cur >= 0 && this.iter.hasNext();
        }

        @Override
        public T next() {
            ++this.cur;
            return this.iter.next();
        }

        @Override
        public void remove() {
        }
    }

    private static class ArrayWLItem
    implements Iterator<Object>,
    WLItem {
        Object[] objs;
        int cur;

        ArrayWLItem(Object[] objs) {
            this.objs = objs;
            this.cur = 0;
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.objs.length;
        }

        @Override
        public Object next() {
            return this.objs[this.cur++];
        }

        @Override
        public void remove() {
        }
    }

    static interface WLItem {
    }
}

