/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.awt.AWTPermission;
import java.awt.Color;
import java.io.FilePermission;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.util.HashSet;
import java.util.PropertyPermission;
import java.util.Set;
import tester.CmdlineArgs;
import tester.Reflector;
import tester.Tester;

public class Main {
    protected static final Set<String> allowed = new HashSet<String>();
    private static SecurityManager saved;

    protected static SecurityManager getManager() {
        return new SecurityManager(){

            @Override
            public void checkExec(String cmd) {
                throw new SecurityException("Not allowed to execute subprocess " + cmd);
            }

            @Override
            public void checkExit(int status) {
                throw new SecurityException("Not allowed to exit");
            }

            @Override
            public void checkDelete(String file) {
                throw new SecurityException("Not allowed to delete file " + file);
            }

            @Override
            public void checkPermission(Permission perm) {
                StackTraceElement[] stack;
                if (allowed.contains(perm.getName())) {
                    return;
                }
                if (perm.getName().equals("setSecurityManager")) {
                    for (StackTraceElement ste : stack = Thread.currentThread().getStackTrace()) {
                        if (!ste.getClassName().equals("tester.Main") || !ste.getMethodName().equals("restoreManager")) continue;
                        return;
                    }
                }
                if (perm.getName().equals("setContextClassLoader")) {
                    for (StackTraceElement ste : stack = Thread.currentThread().getStackTrace()) {
                        if (!ste.getClassName().startsWith("sun.awt.windows.")) continue;
                        return;
                    }
                }
                if (perm instanceof FilePermission) {
                    return;
                }
                if (perm instanceof PropertyPermission) {
                    return;
                }
                if (perm instanceof AWTPermission) {
                    return;
                }
                for (StackTraceElement ste : stack = Thread.currentThread().getStackTrace()) {
                    String className = ste.getClassName();
                    String methodName = ste.getMethodName();
                    if (className.equals("javalib.impworld.World") || className.equals("javalib.funworld.World")) {
                        if (methodName.equals("drawWorld") || methodName.equals("worldEnds")) {
                            super.checkPermission(perm);
                        }
                        if (!methodName.equals("bigBang") && !methodName.equals("stopWorld")) continue;
                        return;
                    }
                    if (className.equals("tester.Printer") && methodName.equals("getIndentedString")) {
                        return;
                    }
                    if (!className.equals("javalib.worldcanvas.WorldSceneBase")) continue;
                    return;
                }
                super.checkPermission(perm);
            }
        };
    }

    private static void setupManager() {
        saved = System.getSecurityManager();
        System.setSecurityManager(Main.getManager());
    }

    private static void restoreManager() {
        System.setSecurityManager(saved);
    }

    public static void main(String[] argv) throws Exception {
        boolean noTests = true;
        CmdlineArgs args = CmdlineArgs.parseArguments(argv);
        new Color(0);
        if (args.useSecmon) {
            Main.setupManager();
        }
        for (String classname : args.testClasses) {
            Object o = null;
            try {
                Class<?> examples = Reflector.classForName(classname);
                if (examples == null && noTests) {
                    throw new ClassNotFoundException("could not find the class " + classname);
                }
                try {
                    Constructor<?> constructor = examples.getDeclaredConstructor(new Class[0]);
                    Reflector.ensureIsAccessible(constructor);
                    o = constructor.newInstance(new Object[0]);
                }
                catch (Throwable exception) {
                    Main.reportExamplesConstructorException(classname, exception);
                }
                if (o != null) {
                    Tester t = new Tester();
                    t.runAnyTests(o, false, true, args.reporter, args.outputWidth);
                    continue;
                }
                if (!noTests) continue;
                throw new RuntimeException("The " + classname + " class could not be instantiated.\n" + "Please check to make sure that your examples class has a default " + "constructor that does not fail during instantiation.");
            }
            catch (ClassNotFoundException c) {
                if (!noTests) continue;
                if (classname != null) {
                    System.err.println(classname + " class doesn't exist.\n" + "Please check to make sure that the argment that gives the name" + " of your examples class has the correct spelling.");
                    continue;
                }
                System.err.println(c.getMessage());
            }
        }
        args.reporter.finishReporting();
        Main.restoreManager();
    }

    private static void reportExamplesConstructorException(String classname, Throwable exception) {
        String excMessage;
        String excName;
        if (exception.getCause() != null) {
            excName = exception.getCause().getClass().getName();
            excMessage = exception.getCause().getMessage();
        } else {
            excName = exception.getClass().getName();
            excMessage = exception.getMessage();
        }
        if (excName.equals("java.lang.NoSuchMethodException")) {
            System.out.println("no default constructor: " + excMessage);
        } else if (excName.equals("java.lang.InvocationTargetException")) {
            System.out.println("Invocation -- Exception thrown by the constructor: \nException: " + excName + "\nMessage: " + excMessage);
        } else if (excName.equals("java.lang.InstantiationException")) {
            System.out.println("Cannot construct an instance of " + classname);
        } else if (excName.equals("java.lang.IllegalAccessException")) {
            System.out.println("Exception: " + excName + "\nMessage: " + excMessage);
        } else {
            System.out.println("Invocation -- Exception thrown by the constructor: \nException: " + excName + "\nMessage: " + excMessage);
        }
    }

    static {
        allowed.add("createSecurityManager");
        allowed.add("createClassLoader");
        allowed.add("suppressAccessChecks");
        allowed.add("accessDeclaredMembers");
        allowed.add("getStackTrace");
        allowed.add("modifyThreadGroup");
        allowed.add("modifyThread");
        allowed.add("specifyStreamHandler");
        allowed.add("java.class.path");
        allowed.add("accessClassInPackage.sun.text.resources");
        allowed.add("accessClassInPackage.sun.util.resources");
        allowed.add("loadLibrary.awt");
    }
}

