/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.util.Stack;
import javalib.worldimages.AlignModeX;
import javalib.worldimages.AlignModeY;
import javalib.worldimages.EmptyImage;
import javalib.worldimages.FieldsWLItem;
import javalib.worldimages.ImageField;
import javalib.worldimages.OverlayOffsetAlignBase;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public final class BesideAlignImage
extends OverlayOffsetAlignBase {
    private BesideAlignImage(AlignModeY mode, WorldImage im1, WorldImage im2) {
        super(AlignModeX.PINHOLE, mode, im1, im1.getWidth() / 2.0 + im2.getWidth() / 2.0, 0.0, im2);
    }

    public BesideAlignImage(AlignModeY mode, WorldImage im1, WorldImage ... ims) {
        this(mode, im1, BesideAlignImage.multipleImageHandling(mode, ims));
    }

    public BesideAlignImage(String mode, WorldImage im1, WorldImage ... ims) {
        this(AlignModeY.fromString(mode), im1, ims);
    }

    private static WorldImage multipleImageHandling(AlignModeY mode, WorldImage[] ims) {
        if (ims.length == 0) {
            return new EmptyImage();
        }
        if (ims.length <= 1) {
            return ims[0];
        }
        WorldImage[] images = new WorldImage[ims.length - 1];
        System.arraycopy(ims, 1, images, 0, images.length);
        return new BesideAlignImage(mode, ims[0], images);
    }

    @Override
    protected StringBuilder toIndentedStringHelp(StringBuilder sb, Stack<Object> stack) {
        sb = sb.append("new ").append(this.simpleName()).append("(").append("this.mode = ").append((Object)this.alignY).append(",");
        stack.push(new FieldsWLItem(this.pinhole, new ImageField("im1", this.top), new ImageField("im2", this.bot)));
        return sb;
    }

    @Override
    public WorldImage movePinholeTo(Posn p) {
        BesideAlignImage i = new BesideAlignImage(this.alignY, this.top, this.bot);
        i.pinhole = p;
        return i;
    }
}

