/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javalib.worldimages.BoundingBox;
import javalib.worldimages.DPosn;
import javalib.worldimages.ImagePrinter;
import javalib.worldimages.OverlayImage;
import javalib.worldimages.Posn;

public abstract class WorldImage {
    public Posn pinhole;
    static WeakHashMap<WorldImage, BoundingBox> bbCache;
    int depth;

    public int getImageNestingDepth() {
        return this.depth;
    }

    protected WorldImage(int depth) {
        this(new Posn(0, 0), depth);
    }

    protected WorldImage(Posn pinhole, int depth) {
        this.pinhole = pinhole;
        this.depth = depth;
        if (bbCache == null) {
            bbCache = new WeakHashMap();
        }
    }

    abstract int numKids();

    abstract WorldImage getKid(int var1);

    abstract AffineTransform getTransform(int var1);

    public BoundingBox getBB() {
        BoundingBox ret = bbCache.get(this);
        if (ret == null) {
            ret = this.getBB(new AffineTransform());
            bbCache.put(this, ret);
        }
        return ret;
    }

    protected BoundingBox getBB(final AffineTransform tx) {
        try {
            if (tx.isIdentity() && bbCache.containsKey(this)) {
                return this.getBB();
            }
            return this.getBBHelp(tx);
        }
        catch (StackOverflowError e) {
            final WorldImage img = this;
            return new Callable<BoundingBox>(){

                @Override
                public BoundingBox call() {
                    return img.getBB(tx);
                }
            }.call();
        }
    }

    protected abstract BoundingBox getBBHelp(AffineTransform var1);

    protected static Point2D transformPosn(AffineTransform t, Posn p) {
        return WorldImage.transformPosn(t, p.x, p.y);
    }

    protected static Point2D transformPosn(AffineTransform t, DPosn p) {
        return WorldImage.transformPosn(t, p.x, p.y);
    }

    protected static Point2D transformPosn(AffineTransform t, double x, double y) {
        Point2D.Double point = new Point2D.Double(x, y);
        return t.transform(point, null);
    }

    public abstract WorldImage movePinholeTo(Posn var1);

    public WorldImage movePinhole(double dx, double dy) {
        return this.movePinholeTo(new Posn((int)Math.round((double)this.pinhole.x + dx), (int)Math.round((double)this.pinhole.y + dy)));
    }

    protected abstract void drawStackUnsafe(Graphics2D var1);

    protected abstract void drawStacksafe(Graphics2D var1, Stack<WorldImage> var2, Stack<AffineTransform> var3);

    public final void draw(Graphics2D g) {
        if (this.depth < 1000) {
            this.drawStackUnsafe(g);
        } else {
            Stack<WorldImage> images = new Stack<WorldImage>();
            Stack<AffineTransform> txs = new Stack<AffineTransform>();
            AffineTransform initTx = g.getTransform();
            images.push(this);
            txs.push(initTx);
            while (!images.isEmpty()) {
                WorldImage nextI = (WorldImage)images.pop();
                AffineTransform nextT = (AffineTransform)txs.pop();
                g.setTransform(nextT);
                nextI.drawStacksafe(g, images, txs);
            }
            g.setTransform(initTx);
        }
    }

    protected final boolean equalsStacksafe(WorldImage that) {
        Stack<WorldImage> worklistThis = new Stack<WorldImage>();
        Stack<WorldImage> worklistThat = new Stack<WorldImage>();
        worklistThis.push(this);
        worklistThat.push(that);
        while (!worklistThis.empty()) {
            WorldImage two;
            WorldImage one = (WorldImage)worklistThis.pop();
            if (one == (two = (WorldImage)worklistThat.pop()) || one.equalsStacksafe(two, worklistThis, worklistThat)) continue;
            return false;
        }
        return true;
    }

    protected abstract boolean equalsStacksafe(WorldImage var1, Stack<WorldImage> var2, Stack<WorldImage> var3);

    public boolean equals(Object obj) {
        return obj instanceof WorldImage && this.equalsStacksafe((WorldImage)obj);
    }

    public WorldImage overlayImages(WorldImage ... args) {
        WorldImage image = this;
        int length = args != null ? args.length : 0;
        for (int i = 0; i < length; ++i) {
            image = new OverlayImage(image, args[i]);
        }
        return image;
    }

    public abstract double getWidth();

    public abstract double getHeight();

    public String toString() {
        return this.toIndentedString(new StringBuilder(), "", 0).toString();
    }

    public StringBuilder toIndentedString(StringBuilder sb, String linePrefix, int indent) {
        return ImagePrinter.makeString(this, sb, linePrefix, indent);
    }

    protected abstract StringBuilder toIndentedStringHelp(StringBuilder var1, Stack<Object> var2);

    protected String simpleName() {
        return this.getClass().getSimpleName();
    }

    protected static String colorString(String indent, Color color) {
        return "\n" + indent + WorldImage.colorString(color);
    }

    protected static String colorString(Color color) {
        String result = color.toString();
        int start = result.indexOf(91);
        result = result.substring(start, result.length());
        return "this.color = " + result;
    }
}

