/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldcanvas;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javalib.impworld.WorldScene;
import javalib.worldcanvas.CanvasPanel;
import javalib.worldcanvas.WorldSceneBase;
import javalib.worldimages.CircleImage;
import javax.swing.JFrame;

public class WorldCanvas {
    protected static int WINDOWS_OPEN = 0;
    public transient JFrame f;
    public transient CanvasPanel panel;
    protected int width;
    protected int height;
    protected transient WindowAdapter winapt = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            WorldCanvas.this.panel.clearPanel();
            if (--WINDOWS_OPEN == 0) {
                System.exit(0);
            }
        }
    };

    public WorldCanvas(int width, int height, String title) {
        this.width = width;
        this.height = height;
        this.f = new JFrame(title);
        this.f.setLayout(new BorderLayout());
        this.f.setResizable(false);
        this.f.addWindowListener(this.winapt);
        this.f.setDefaultCloseOperation(1);
        this.panel = new CanvasPanel(width, height);
        this.panel.addNotify();
        this.f.getContentPane().add((Component)this.panel, "Center");
        this.f.getContentPane().setMinimumSize(new Dimension(width, height));
        this.f.pack();
        Graphics g = this.panel.getGraphics();
        this.f.update(g);
        this.f.setVisible(false);
    }

    public WorldCanvas(int width, int height) {
        this(width, height, "Canvas");
    }

    public final Graphics2D getBufferGraphics() {
        return this.panel.getBufferGraphics();
    }

    public boolean drawScene(WorldSceneBase scene) {
        if (this.f.getWidth() != scene.width || this.f.getHeight() != scene.height) {
            this.f.getContentPane().setMinimumSize(new Dimension(scene.width, scene.height));
        }
        this.panel.drawScene(scene);
        return true;
    }

    public void printCurrentFont() {
        this.panel.getFont();
    }

    public boolean show() {
        if (!this.f.isVisible()) {
            ++WINDOWS_OPEN;
            this.f.setVisible(true);
            return true;
        }
        return true;
    }

    public boolean close() {
        if (this.f.isVisible()) {
            --WINDOWS_OPEN;
            this.f.setVisible(false);
            this.panel.clearPanel();
        }
        return true;
    }

    public void clear() {
        this.panel.clearPanel();
    }

    private static void nextStep(String message) {
        try {
            System.out.println(message);
            System.out.println("Press RETURN");
            System.in.read();
        }
        catch (IOException e) {
            System.out.println("Next step");
        }
    }

    public String toString() {
        return "new Canvas(" + this.width + ", " + this.height + ")";
    }

    public String toIndentedString(String indent) {
        return "new Canvas(" + this.width + ", " + this.height + ")";
    }

    public static void main(String[] argv) {
        WorldCanvas.nextStep("Canvas with default name is constructed");
        WorldCanvas sm1 = new WorldCanvas(200, 200);
        WorldCanvas.nextStep("To show the canvas ... ");
        sm1.show();
        WorldScene scene1 = new WorldScene(200, 200);
        WorldCanvas.nextStep("Canvas shown - should be blank - add red and blue disk");
        scene1.placeImageXY(new CircleImage(20, "outline", Color.red), 50, 50);
        scene1.placeImageXY(new CircleImage(20, "outline", Color.blue), 150, 50);
        sm1.drawScene(scene1);
        WorldCanvas.nextStep("Show the canvas again - it should not do anything");
        sm1.show();
        WorldCanvas.nextStep("Draw a green disk");
        scene1.placeImageXY(new CircleImage(50, "outline", Color.green), 50, 150);
        sm1.drawScene(scene1);
        WorldCanvas.nextStep("Close the Canvas");
        sm1.close();
        WorldCanvas.nextStep("Show the canvas again - it should be cleared");
        sm1.show();
        WorldCanvas.nextStep("Paint one disks on the canvas");
        WorldScene scene2 = new WorldScene(200, 200);
        scene2.placeImageXY(new CircleImage(25, "outline", Color.black), 50, 150);
        sm1.drawScene(scene2);
        WorldCanvas.nextStep("Construct a second canvas with the name Smiley");
        WorldCanvas sm2 = new WorldCanvas(200, 200, "Smiley");
        WorldCanvas.nextStep("Show the second canvas");
        sm2.show();
        WorldCanvas.nextStep("Paint two disks on the Smiley canvas");
        WorldScene scene3 = new WorldScene(200, 200);
        scene3.placeImageXY(new CircleImage(20, "outline", Color.red), 50, 50);
        scene3.placeImageXY(new CircleImage(50, "outline", Color.blue), 150, 50);
        sm2.drawScene(scene3);
        WorldCanvas.nextStep("Manually close the 'Canvas' windowand see if we can bring it back to life");
        sm1.show();
        WorldCanvas.nextStep("The first canvas should be shown - cleared");
        WorldScene scene4 = new WorldScene(200, 200);
        scene4.placeImageXY(new CircleImage(30, "outline", Color.red), 50, 50);
        scene4.placeImageXY(new CircleImage(30, "outline", Color.blue), 150, 50);
        scene4.placeImageXY(new CircleImage(30, "outline", Color.green), 50, 150);
        sm1.drawScene(scene4);
        WorldCanvas.nextStep("The first canvas has three disks drawn");
        System.out.println("Close both canvas windows to end the program");
    }
}

