/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import tester.DefaultReporter;
import tester.OutputReporter;
import tester.TAPReporter;

class CmdlineArgs {
    public final OutputReporter reporter;
    public final int outputWidth;
    public final List<String> testClasses;
    public final boolean useSecmon;
    public final boolean enforceTimeouts;
    public static final int DEFAULT_OUTPUT_WIDTH = 48;

    private CmdlineArgs(OutputReporter reporter, int outputWidth, List<String> classNames, boolean useSecmon, boolean enforceTimeouts) {
        this.reporter = reporter;
        this.outputWidth = outputWidth;
        this.testClasses = classNames;
        this.useSecmon = useSecmon;
        this.enforceTimeouts = enforceTimeouts;
    }

    public static CmdlineArgs parseArguments(String[] argv) {
        LinkedList<Object> testClasses;
        OutputReporter reporter = null;
        int outputWidth = 48;
        boolean useSecmon = false;
        boolean enforceTimeouts = false;
        if (argv == null) {
            testClasses = new LinkedList<String>();
            testClasses.add("Examples");
        } else {
            testClasses = new LinkedList<String>(Arrays.asList(argv));
        }
        while (!testClasses.isEmpty() && ((String)testClasses.get(0)).startsWith("-")) {
            if (((String)testClasses.get(0)).equals("-secmon")) {
                useSecmon = true;
                testClasses.remove(0);
                continue;
            }
            if (((String)testClasses.get(0)).equals("-tap")) {
                reporter = new TAPReporter(System.out);
                testClasses.remove(0);
                continue;
            }
            if (((String)testClasses.get(0)).equals("-enforceTimeouts")) {
                enforceTimeouts = true;
                testClasses.remove(0);
                continue;
            }
            if (testClasses.size() > 1 && ((String)testClasses.get(0)).equals("-width")) {
                outputWidth = Integer.parseInt((String)testClasses.get(1));
                testClasses.remove(0);
                testClasses.remove(0);
                continue;
            }
            System.err.println("Warning: unknown flag " + (String)testClasses.get(0));
            testClasses.remove(0);
        }
        if (reporter == null) {
            reporter = new DefaultReporter();
        }
        return new CmdlineArgs(reporter, outputWidth, testClasses, useSecmon, enforceTimeouts);
    }
}

