/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tester.Inspector;
import tester.Reflector;
import tester.Traversal;

public class Printer {
    private static int INDENT = 0;
    private static int counter;
    private static HashMap<Integer, Integer> objIdsMap;
    private static HashSet<Integer> alreadyPrinted;
    private static Map<Integer, String> indentations;

    public static void print(Object obj) {
        objIdsMap.clear();
        counter = 0;
        StringBuilder sb = new StringBuilder();
        System.out.println(Printer.makeString(obj, sb).toString());
    }

    public static String produceString(Object obj) {
        return Printer.produceString(obj, false);
    }

    public static String produceString(Object obj, boolean resetVisibilityOnly) {
        alreadyPrinted.clear();
        if (!resetVisibilityOnly) {
            objIdsMap.clear();
            counter = 0;
        }
        return Printer.produceString(obj, new StringBuilder()).toString();
    }

    private static StringBuilder produceString(Object obj, StringBuilder sb) {
        return Printer.makeString(obj, sb);
    }

    public static <T> String produceTraversalStrings(Traversal<T> tr) {
        return Printer.produceTraversalStrings(tr, false);
    }

    public static <T> String produceTraversalStrings(Traversal<T> tr, boolean resetVisibilityOnly) {
        alreadyPrinted.clear();
        if (!resetVisibilityOnly) {
            objIdsMap.clear();
            counter = 0;
        }
        return Printer.produceTraversalStrings(tr, new StringBuilder()).toString();
    }

    private static <T> StringBuilder produceTraversalStrings(Traversal<T> tr, StringBuilder sb) {
        return Printer.makeTraversalStrings(tr, sb);
    }

    private static StringBuilder makeString(Object obj, StringBuilder sb) {
        Stack<Object> worklist = new Stack<Object>();
        int valueCount = 0;
        worklist.push(obj);
        while (!worklist.empty()) {
            obj = worklist.peek();
            if (worklist.size() > 100 || ++valueCount > 1000) {
                if (obj instanceof ArrayWLItem) {
                    ((ArrayWLItem)obj).skipToEnd();
                } else if (obj instanceof IteratorWLItem) {
                    ((IteratorWLItem)obj).skipToEnd();
                } else if (obj instanceof MapWLItem) {
                    ((MapWLItem)obj).skipToEnd();
                } else if (obj instanceof FieldsWLItem) {
                    ((FieldsWLItem)obj).skipToEnd();
                } else {
                    if (obj == null) {
                        sb = sb.append("null");
                        worklist.pop();
                        continue;
                    }
                    Class<?> objClass = obj.getClass();
                    if (obj instanceof String) {
                        sb = sb.append("\"").append(((String)obj).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                    } else if (obj instanceof Random) {
                        sb = sb.append("new Random()");
                    } else if (obj instanceof Color) {
                        String result = obj.toString();
                        int start = result.indexOf(91);
                        result = result.substring(start, result.length());
                        sb = sb.append(result);
                    } else if (obj instanceof Enum) {
                        Enum e = (Enum)obj;
                        sb = sb.append(e.getDeclaringClass().getName().replace('$', '.')).append(".").append(e.name());
                    } else {
                        sb = objClass.isPrimitive() || Inspector.isWrapperClass(objClass.getName()) ? sb.append(Printer.makePrimitiveStrings(objClass.getName(), obj)) : (valueCount > 1000 ? sb.append("<truncated; too many objects to print>") : sb.append("<truncated; objects are too deeply nested to print>"));
                    }
                    worklist.pop();
                    continue;
                }
            }
            if (obj == null) {
                sb = sb.append("null");
                worklist.pop();
                continue;
            }
            if (obj instanceof String) {
                sb = sb.append("\"").append(((String)obj).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                worklist.pop();
                continue;
            }
            if (obj instanceof Random) {
                sb = sb.append("new Random()");
                worklist.pop();
                continue;
            }
            if (obj instanceof Color) {
                String result = obj.toString();
                int start = result.indexOf(91);
                result = result.substring(start, result.length());
                sb = sb.append(result);
                worklist.pop();
                continue;
            }
            if (obj instanceof Enum) {
                Enum e = (Enum)obj;
                sb = sb.append(e.getDeclaringClass().getName().replace('$', '.')).append(".").append(e.name());
                worklist.pop();
                continue;
            }
            Method tism = Printer.toIndentedStringMethodSB(obj);
            if (tism != null) {
                sb = Printer.getIndentedString(obj, tism, sb, Printer.indentation(INDENT), 1);
                worklist.pop();
                continue;
            }
            tism = Printer.toIndentedStringMethod(obj);
            if (tism != null) {
                sb = sb.append(Printer.getIndentedString(obj, tism));
                worklist.pop();
                continue;
            }
            Class<?> objClass = obj.getClass();
            if (objClass.isPrimitive() || Inspector.isWrapperClass(objClass.getName())) {
                sb = sb.append(Printer.makePrimitiveStrings(objClass.getName(), obj));
                worklist.pop();
                continue;
            }
            if (Inspector.isWorldImage(objClass)) {
                sb = sb.append(obj.toString());
                worklist.pop();
                continue;
            }
            Integer objHash = System.identityHashCode(obj);
            Integer objUniqId = objIdsMap.get(objHash);
            if (objUniqId == null && !(obj instanceof WLItem)) {
                objUniqId = ++counter;
                objIdsMap.put(objHash, counter);
            }
            if (alreadyPrinted.contains(objHash)) {
                sb = sb.append(obj.getClass().getName() + ":" + objUniqId);
                worklist.pop();
                continue;
            }
            if (!(obj instanceof WLItem)) {
                alreadyPrinted.add(objHash);
            }
            if (Inspector.isOurCanvas(obj.getClass().getName())) {
                sb = sb.append(obj.toString());
                worklist.pop();
                continue;
            }
            if (obj instanceof Object[]) {
                int length = Array.getLength(obj);
                sb.append("new Object[" + length + "](){");
                ++INDENT;
                worklist.pop();
                worklist.push(new ArrayWLItem((Object[])obj, false));
                continue;
            }
            if (obj instanceof Iterable && obj.getClass().getName().startsWith("java.util")) {
                sb = sb.append("new ").append(objClass.getName()).append(":").append(objUniqId).append("(){\n");
                ++INDENT;
                worklist.pop();
                worklist.push(new IteratorWLItem(((Iterable)obj).iterator(), true));
                continue;
            }
            if (obj instanceof Map) {
                sb = sb.append("new ").append(objClass.getName()).append(":").append(objUniqId).append("(){");
                ++INDENT;
                worklist.pop();
                worklist.push(new MapWLItem(((Map)obj).entrySet().iterator()));
                continue;
            }
            if (obj instanceof ArrayWLItem) {
                ArrayWLItem arrayWLItem = (ArrayWLItem)obj;
                if (arrayWLItem.hasNext()) {
                    if (!arrayWLItem.first()) {
                        sb.append(",");
                    }
                    sb = sb.append("\n").append(Printer.indentation(INDENT));
                    if (arrayWLItem.showNums) {
                        sb.append("[").append(arrayWLItem.cur).append("] ");
                    }
                    worklist.push(arrayWLItem.next());
                    continue;
                }
                sb = sb.append("\n").append(Printer.indentation(--INDENT)).append("}");
                worklist.pop();
                continue;
            }
            if (obj instanceof IteratorWLItem) {
                IteratorWLItem iterWLItem = (IteratorWLItem)obj;
                if (iterWLItem.hasNext()) {
                    if (!iterWLItem.first()) {
                        sb.append(",\n");
                    }
                    sb = sb.append(Printer.indentation(INDENT)).append("Iterable[").append(iterWLItem.cur).append("] ");
                    worklist.push(iterWLItem.next());
                    continue;
                }
                sb = sb.append("\n").append(Printer.indentation(--INDENT)).append("}");
                worklist.pop();
                continue;
            }
            if (obj instanceof MapWLItem) {
                MapWLItem mapWLItem = (MapWLItem)obj;
                if (mapWLItem.hasNext()) {
                    boolean onKey;
                    boolean bl = onKey = !mapWLItem.onValue;
                    if (!mapWLItem.first() && onKey) {
                        sb.append("),");
                        --INDENT;
                    }
                    Object entry = mapWLItem.next();
                    if (onKey) {
                        sb = sb.append("\n").append(Printer.indentation(INDENT)).append("(key: ");
                        ++INDENT;
                        worklist.push(entry.getKey());
                        continue;
                    }
                    sb = sb.append("\n").append(Printer.indentation(--INDENT)).append(" value: ");
                    ++INDENT;
                    worklist.push(entry.getValue());
                    continue;
                }
                if (mapWLItem.first()) {
                    sb.append("\n").append(Printer.indentation(--INDENT)).append("}");
                } else {
                    sb = sb.append(")\n").append(Printer.indentation(INDENT -= 2)).append("}");
                }
                worklist.pop();
                continue;
            }
            if (obj instanceof FieldsWLItem) {
                FieldsWLItem fieldsWLItem = (FieldsWLItem)obj;
                if (fieldsWLItem.hasNext()) {
                    Field f = fieldsWLItem.next();
                    try {
                        Reflector.ensureIsAccessible(f);
                        sb = sb.append("\n").append(Printer.indentation(INDENT)).append("this.").append(f.getName()).append(" = ");
                        worklist.push(f.get(fieldsWLItem.obj));
                    }
                    catch (IllegalAccessException e) {
                        System.out.println("makeString cannot access the field " + f.getName() + " of the class " + fieldsWLItem.obj.getClass().getName() + "\n   message: " + e.getMessage());
                    }
                    continue;
                }
                --INDENT;
                sb = sb.append(")");
                worklist.pop();
                continue;
            }
            sb = sb.append("new ").append(objClass.getName()).append(":").append(objUniqId).append("(");
            ++INDENT;
            worklist.pop();
            worklist.push(new FieldsWLItem(obj, new Reflector((Object)obj).sampleDeclaredFields));
            String customToString = Printer.hasDefinedToString(obj);
            if (customToString == null || customToString.equals("")) continue;
            sb = sb.append("\n").append(Printer.indentation(INDENT)).append("\"").append(customToString).append("\"");
        }
        return sb;
    }

    private static <T> String makePrimitiveStrings(String className, T value) {
        StringBuilder result = new StringBuilder();
        if (className.equals("java.lang.Short")) {
            return result + value.toString() + "S";
        }
        if (className.equals("java.lang.Long")) {
            return result + value.toString() + "L";
        }
        if (className.equals("java.lang.Float")) {
            return result + value.toString() + "F";
        }
        if (className.equals("java.math.BigInteger")) {
            return result + value.toString() + "BigInteger";
        }
        if (className.equals("java.math.BigDecimal")) {
            return result + value.toString() + "BigDecimal";
        }
        return result + value.toString();
    }

    private static <T> StringBuilder makeTraversalStrings(Traversal<T> tr, StringBuilder sb) {
        int n = 0;
        while (!tr.isEmpty()) {
            if (n > 0) {
                sb = sb.append(",");
            }
            sb = sb.append("\n").append(Printer.indentation(INDENT)).append("Traversal[").append(n).append("] ");
            sb = Printer.makeString(tr.getFirst(), sb);
            ++n;
            tr = tr.getRest();
        }
        return sb;
    }

    private static String hasDefinedToString(Object o) {
        Method tsm = null;
        Class<?> c = o.getClass();
        while (c != null) {
            try {
                tsm = c.getDeclaredMethod("toString", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (tsm != null) {
                try {
                    Class<?> defclass = tsm.getDeclaringClass();
                    if (defclass.getName().equals("java.lang.Object") || defclass.getName().equals("java.util.AbstractCollection")) {
                        return "";
                    }
                    Reflector.ensureIsAccessible(tsm);
                    return (String)tsm.invoke(o, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    System.out.println("IllegalAccessException:" + e.getMessage());
                    System.out.println("Incorrectly invoked toString method in the class:" + o.getClass().getName() + "\n");
                    continue;
                }
                catch (InvocationTargetException e) {
                    System.out.println("InvocationTargetException:" + e.getMessage());
                    System.out.println("Incorrectly invoked toString method in the class:" + o.getClass().getName() + "\n");
                    continue;
                }
            }
            c = c.getSuperclass();
        }
        return "";
    }

    private static Method toIndentedStringMethod(Object o) {
        Method tsm = null;
        Class<?> c = o.getClass();
        if (c != null) {
            try {
                tsm = c.getDeclaredMethod("toIndentedString", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return tsm;
        }
        return null;
    }

    private static Method toIndentedStringMethodSB(Object o) {
        Object tsm = null;
        for (Class<?> c = o.getClass(); c != null && !c.getName().equals("java.lang.Object"); c = c.getSuperclass()) {
            try {
                return c.getMethod("toIndentedString", StringBuilder.class, String.class, Integer.TYPE);
            }
            catch (NoSuchMethodException e) {
                continue;
            }
        }
        return null;
    }

    private static String indentation(int indent) {
        String ans = indentations.get(indent);
        if (ans == null) {
            char[] spaces = new char[indent];
            Arrays.fill(spaces, ' ');
            ans = new String(spaces);
            indentations.put(indent, ans);
        }
        return ans;
    }

    private static String getIndentedString(Object o, Method tism) {
        try {
            Reflector.ensureIsAccessible(tism);
            return (String)tism.invoke(o, Printer.indentation(INDENT));
        }
        catch (IllegalAccessException e) {
            System.out.println("IllegalAccessException:" + e.getMessage());
            System.out.println("Incorrectly invoked toIndentedString method in the class:" + o.getClass().getName() + "\n");
        }
        catch (InvocationTargetException e) {
            System.out.println("InvocationTargetException:" + e.getMessage());
            System.out.println("Incorrectly invoked toIndentedString method in the class:" + o.getClass().getName() + "\n");
        }
        return "";
    }

    private static StringBuilder getIndentedString(Object o, Method tism, StringBuilder sb, String linePrefix, int indent) {
        try {
            Reflector.ensureIsAccessible(tism);
            return (StringBuilder)tism.invoke(o, sb, linePrefix, indent);
        }
        catch (IllegalAccessException e) {
            System.out.println("IllegalAccessException:" + e.getMessage());
            System.out.println("Incorrectly invoked toIndentedString method in the class:" + o.getClass().getName() + "\n");
        }
        catch (InvocationTargetException e) {
            System.out.println("InvocationTargetException:" + e.getMessage());
            System.out.println("Incorrectly invoked toIndentedString method in the class:" + o.getClass().getName() + "\n");
        }
        return sb;
    }

    protected static String combineActualExpected(String actual, String expected, int width) {
        char[] repeat = new char[width + 2];
        Arrays.fill(repeat, ' ');
        String space = new String(repeat);
        Arrays.fill(repeat, '.');
        String fill = new String(repeat);
        StringBuilder combined = new StringBuilder("");
        StringTokenizer actLine = new StringTokenizer(actual, "\n");
        StringTokenizer expLine = new StringTokenizer(expected, "\n");
        String actString = actLine.nextToken();
        String expString = expLine.nextToken();
        while (Printer.equivModuloIdNums(expString, actString)) {
            combined.append(Printer.combineSpaceFill(actString, expString, space, width));
            if (!expLine.hasMoreTokens()) {
                return Printer.finishActual(combined, actLine);
            }
            if (!actLine.hasMoreTokens()) {
                return Printer.finishExpected(combined, expLine, space);
            }
            actString = actLine.nextToken();
            expString = expLine.nextToken();
        }
        combined.append(Printer.combineSpaceFill(actString, expString, fill, width));
        while (expLine.hasMoreTokens() && actLine.hasMoreTokens()) {
            actString = actLine.nextToken();
            expString = expLine.nextToken();
            combined.append(Printer.combineSpaceFill(actString, expString, space, width));
        }
        if (!expLine.hasMoreTokens()) {
            return Printer.finishActual(combined, actLine);
        }
        if (!actLine.hasMoreTokens()) {
            return Printer.finishExpected(combined, expLine, space);
        }
        return combined.toString();
    }

    private static boolean equivModuloIdNums(String act, String exp) {
        Pattern newObj = Pattern.compile("(.*new [^:]+:)(\\d+)(\\(.*)");
        Matcher actMatch = newObj.matcher(act);
        Matcher expMatch = newObj.matcher(exp);
        if (actMatch.matches() && expMatch.matches() && actMatch.group(1).equals(expMatch.group(1))) {
            act = actMatch.group(1) + actMatch.group(2);
            exp = expMatch.group(1) + actMatch.group(2);
            return act.equals(exp);
        }
        return act.equals(exp);
    }

    private static String combineSpaceFill(String act, String exp, String spfill, int count) {
        if (act.length() > count) {
            return "\n--  actual  : " + act + spfill.substring(0, 10) + "\n" + "\n--  expected: " + exp + "\n\n";
        }
        return act + spfill.substring(0, count + 2 - act.length()) + exp + "\n";
    }

    private static String finishActual(StringBuilder combined, StringTokenizer actLine) {
        while (actLine.hasMoreTokens()) {
            combined.append(actLine.nextToken() + "\n");
        }
        return combined.toString();
    }

    private static String finishExpected(StringBuilder combined, StringTokenizer expLine, String space) {
        while (expLine.hasMoreTokens()) {
            combined.append(space + expLine.nextToken() + "\n");
        }
        return combined.toString();
    }

    public static void main(String[] argv) {
        String act = "hello\ngoodbye\nadieau\n";
        String expTrue = "hello\ngoodbye\nadieau\n";
        String expFalse1 = "hello\ngoodbyes\nadieau\n";
        String expFalse2 = "hello\ngoodbye\n";
        String expFalse3 = "hello\ngoodbyes\nadieau\nahoy\n";
        String longact = "abcdefghijklmnopqrtsuvwxyzabcdefghijklmnopqrtsuvwxyz";
        String longexp = "abcdefghijklmnopqrtsuvwxyzabcdefghijklmnopqrtsuvwxyz";
        String longexpbad = "abcdefghijklmnopqrtsuvwxyzabcdefghijklmnopqrtsuvwxyz1";
        System.out.println(Printer.combineActualExpected(act, expTrue, 48));
        System.out.println(Printer.combineActualExpected(act, expFalse1, 48));
        System.out.println(Printer.combineActualExpected(act, expFalse2, 48));
        System.out.println(Printer.combineActualExpected(act, expFalse3, 48));
        System.out.println(Printer.combineActualExpected(longact, longexp, 48));
        System.out.println(Printer.combineActualExpected(longact, longexpbad, 48));
    }

    static {
        objIdsMap = new HashMap();
        alreadyPrinted = new HashSet();
        indentations = new HashMap<Integer, String>();
    }

    private static class FieldsWLItem
    implements Iterator<Field>,
    WLItem {
        Object obj;
        Field[] fields;
        int cur;

        FieldsWLItem(Object obj, Field[] fields) {
            this.obj = obj;
            this.fields = fields;
        }

        boolean first() {
            return this.cur == 0;
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.fields.length;
        }

        @Override
        public Field next() {
            return this.fields[this.cur++];
        }

        @Override
        public void remove() {
        }

        void skipToEnd() {
            this.cur = this.fields.length;
        }
    }

    private static class MapWLItem
    implements Iterator<Map.Entry<Object, Object>>,
    WLItem {
        Iterator<Map.Entry<Object, Object>> iter;
        boolean onValue;
        boolean first;
        boolean skipToEnd;
        Map.Entry<Object, Object> cur;

        MapWLItem(Iterator<Map.Entry<Object, Object>> iter) {
            this.iter = iter;
            this.cur = null;
            this.onValue = false;
            this.first = true;
            this.skipToEnd = true;
        }

        boolean first() {
            return this.first;
        }

        @Override
        public boolean hasNext() {
            return !this.skipToEnd && (this.onValue || this.iter.hasNext());
        }

        @Override
        public Map.Entry<Object, Object> next() {
            if (this.cur == null) {
                this.cur = this.iter.next();
                this.onValue = false;
            }
            Map.Entry<Object, Object> ret = this.cur;
            if (this.onValue) {
                this.onValue = false;
                this.first = false;
                this.cur = null;
            } else {
                this.onValue = true;
            }
            return ret;
        }

        @Override
        public void remove() {
        }

        void skipToEnd() {
            this.skipToEnd = true;
        }
    }

    private static class IteratorWLItem<T>
    implements Iterator<T>,
    WLItem {
        Iterator<T> iter;
        int cur;
        boolean showNums;

        IteratorWLItem(Iterator<T> iter, boolean showNums) {
            this.iter = iter;
            this.cur = 0;
            this.showNums = showNums;
        }

        boolean first() {
            return this.cur == 0;
        }

        @Override
        public boolean hasNext() {
            return this.cur >= 0 && this.iter.hasNext();
        }

        @Override
        public T next() {
            ++this.cur;
            return this.iter.next();
        }

        @Override
        public void remove() {
        }

        void skipToEnd() {
            this.cur = -1;
        }
    }

    private static class ArrayWLItem
    implements Iterator<Object>,
    WLItem {
        Object[] objs;
        int cur;
        boolean showNums;

        ArrayWLItem(Object[] objs, boolean showNums) {
            this.objs = objs;
            this.cur = 0;
            this.showNums = showNums;
        }

        boolean first() {
            return this.cur == 0;
        }

        @Override
        public boolean hasNext() {
            return this.cur < this.objs.length;
        }

        @Override
        public Object next() {
            return this.objs[this.cur++];
        }

        @Override
        public void remove() {
        }

        void skipToEnd() {
            this.cur = this.objs.length;
        }
    }

    static interface WLItem {
    }
}

