/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Stack;
import javalib.worldimages.BoundingBox;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

public final class FrozenImage
extends WorldImage {
    BufferedImage img;

    public FrozenImage(WorldImage img) {
        super(1);
        this.img = new BufferedImage((int)img.getWidth(), (int)img.getHeight(), 3);
        Graphics2D g = this.img.createGraphics();
        g.translate(img.getWidth() / 2.0, img.getHeight() / 2.0);
        img.draw(g);
        g.dispose();
        this.pinhole = img.pinhole;
    }

    private FrozenImage(BufferedImage img, Posn pinhole) {
        super(pinhole, 1);
        this.img = img;
    }

    @Override
    int numKids() {
        return 0;
    }

    @Override
    WorldImage getKid(int i) {
        throw new IllegalArgumentException("No such kid " + i);
    }

    @Override
    AffineTransform getTransform(int i) {
        throw new IllegalArgumentException("No such kid " + i);
    }

    @Override
    protected BoundingBox getBBHelp(AffineTransform t) {
        return new BoundingBox(WorldImage.transformPosn(t, 0.0, 0.0), WorldImage.transformPosn(t, this.getWidth(), this.getHeight()));
    }

    @Override
    public WorldImage movePinholeTo(Posn p) {
        return new FrozenImage(this.img, p);
    }

    @Override
    protected void drawStackUnsafe(Graphics2D g) {
        g.drawImage(this.img, AffineTransform.getTranslateInstance(-this.getWidth() / 2.0, -this.getHeight() / 2.0), null);
    }

    @Override
    protected void drawStacksafe(Graphics2D g, Stack<WorldImage> images, Stack<AffineTransform> txs) {
        this.drawStackUnsafe(g);
    }

    @Override
    public double getWidth() {
        return this.img.getWidth();
    }

    @Override
    public double getHeight() {
        return this.img.getHeight();
    }

    @Override
    protected StringBuilder toIndentedStringHelp(StringBuilder sb, Stack<Object> stack) {
        sb = this.pinhole.x != 0 || this.pinhole.y != 0 ? sb.append("new FrozenImage(pinhole = ").append(this.pinhole.toString()).append(")") : sb.append("new FrozenImage()");
        return sb;
    }

    @Override
    protected boolean equalsStacksafe(WorldImage other, Stack<WorldImage> worklistThis, Stack<WorldImage> worklistThat) {
        if (other instanceof FrozenImage && this.pinhole.equals(other.pinhole)) {
            FrozenImage that = (FrozenImage)other;
            BufferedImage imgA = this.img;
            BufferedImage imgB = that.img;
            if (imgA.getWidth() == imgB.getWidth() && imgA.getHeight() == imgB.getHeight()) {
                int width = imgA.getWidth();
                int height = imgA.getHeight();
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (imgA.getRGB(x, y) == imgB.getRGB(x, y)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }
}

