/*
 * Decompiled with CFR 0.152.
 */
package javalib.worldimages;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import javalib.worldimages.FieldsWLItem;
import javalib.worldimages.ImageField;
import javalib.worldimages.Posn;
import javalib.worldimages.WorldImage;

class ImagePrinter {
    private static Map<Integer, String> indentations = new HashMap<Integer, String>();

    ImagePrinter() {
    }

    private static String indentation(int INDENT) {
        String ans = indentations.get(INDENT);
        if (ans == null) {
            char[] spaces = new char[INDENT];
            Arrays.fill(spaces, ' ');
            ans = new String(spaces);
            indentations.put(INDENT, ans);
        }
        return ans;
    }

    private static boolean isWrapperClass(String name) {
        return name.equals("java.lang.Integer") || name.equals("java.lang.Long") || name.equals("java.lang.Short") || name.equals("java.math.BigInteger") || name.equals("java.math.BigDecimal") || name.equals("java.lang.Float") || name.equals("java.lang.Double") || name.equals("java.lang.Byte") || name.equals("java.lang.Boolean") || name.equals("java.lang.Character");
    }

    private static <T> String makePrimitiveStrings(String className, T value) {
        StringBuilder result = new StringBuilder();
        if (className.equals("java.lang.Short")) {
            return result + value.toString() + "S";
        }
        if (className.equals("java.lang.Long")) {
            return result + value.toString() + "L";
        }
        if (className.equals("java.lang.Float")) {
            return result + value.toString() + "F";
        }
        if (className.equals("java.math.BigInteger")) {
            return result + value.toString() + "BigInteger";
        }
        if (className.equals("java.math.BigDecimal")) {
            return result + value.toString() + "BigDecimal";
        }
        return result + value.toString();
    }

    static StringBuilder makeString(Object obj, StringBuilder sb, String linePrefix, int indent) {
        int INDENT = 0;
        Stack<Object> worklist = new Stack<Object>();
        int valueCount = 0;
        worklist.push(obj);
        while (!worklist.empty()) {
            obj = worklist.peek();
            if (worklist.size() > 100 || ++valueCount > 1000) {
                if (obj instanceof FieldsWLItem) {
                    ((FieldsWLItem)obj).skipToEnd();
                } else {
                    Class<?> objClass = obj.getClass();
                    if (obj == null) {
                        sb = sb.append("null");
                    } else if (obj instanceof String) {
                        sb = sb.append("\"").append(((String)obj).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                    } else if (obj instanceof Random) {
                        sb = sb.append("new Random()");
                    } else if (obj instanceof Color) {
                        String result = obj.toString();
                        int start = result.indexOf(91);
                        result = result.substring(start, result.length());
                        sb = sb.append(result);
                    } else if (obj instanceof Enum) {
                        Enum e = (Enum)obj;
                        sb = sb.append(e.getDeclaringClass().getName().replace('$', '.')).append(".").append(e.name());
                    } else {
                        sb = objClass.isPrimitive() || ImagePrinter.isWrapperClass(objClass.getName()) ? sb.append(ImagePrinter.makePrimitiveStrings(objClass.getName(), obj)) : (valueCount > 1000 ? sb.append("<truncated; too many objects to print>") : sb.append("<truncated; objects are too deeply nested to print>"));
                    }
                    worklist.pop();
                    continue;
                }
            }
            if (obj == null) {
                sb = sb.append("null");
                worklist.pop();
                continue;
            }
            if (obj instanceof String) {
                sb = sb.append("\"").append(((String)obj).replace("\\", "\\\\").replace("\"", "\\\"")).append("\"");
                worklist.pop();
                continue;
            }
            if (obj instanceof Random) {
                sb = sb.append("new Random()");
                worklist.pop();
                continue;
            }
            if (obj instanceof Color) {
                String result = obj.toString();
                int start = result.indexOf(91);
                result = result.substring(start, result.length());
                sb = sb.append(result);
                worklist.pop();
                continue;
            }
            if (obj instanceof Posn) {
                sb = sb.append(((Posn)obj).coords());
                worklist.pop();
                continue;
            }
            if (obj instanceof Enum) {
                Enum e = (Enum)obj;
                sb = sb.append(e.getDeclaringClass().getSimpleName().replace('$', '.')).append(".").append(e.name());
                worklist.pop();
                continue;
            }
            if (obj.getClass().isPrimitive() || ImagePrinter.isWrapperClass(obj.getClass().getName())) {
                sb = sb.append(ImagePrinter.makePrimitiveStrings(obj.getClass().getName(), obj));
                worklist.pop();
                continue;
            }
            if (obj instanceof WorldImage) {
                WorldImage img = (WorldImage)obj;
                INDENT += indent;
                worklist.pop();
                sb = img.toIndentedStringHelp(sb, worklist);
                continue;
            }
            if (obj instanceof FieldsWLItem) {
                FieldsWLItem fieldsWLItem = (FieldsWLItem)obj;
                if (fieldsWLItem.hasNext()) {
                    if (!fieldsWLItem.first()) {
                        sb = sb.append(",");
                    }
                    ImageField f = fieldsWLItem.next();
                    sb = f.noNewlineBefore ? sb.append(" ") : sb.append("\n").append(linePrefix).append(ImagePrinter.indentation(INDENT));
                    sb = sb.append("this.").append(f.name).append(" = ");
                    worklist.push(f.value);
                    continue;
                }
                INDENT -= indent;
                sb = sb.append(")");
                worklist.pop();
                continue;
            }
            sb = sb.append("Unknown object: ").append(obj.getClass().getName()).append("\n").append(obj.toString());
            worklist.pop();
        }
        return sb;
    }
}

