/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import tester.OutputReporter;
import tester.TestResults.StackOverflow;
import tester.TestResults.TestFailure;
import tester.TestResults.TestResult;
import tester.TestResults.TestTimedOut;

public class TAPReporter
implements OutputReporter {
    private final OutputStream delayedOut = new ByteArrayOutputStream();
    private final PrintStream origStdout;
    private final long startTime;
    private final List<TestResult> tests;

    public TAPReporter() {
        this(System.out);
    }

    public TAPReporter(PrintStream origStdout) {
        this.origStdout = origStdout;
        System.setOut(new PrintStream(this.delayedOut, true));
        this.startTime = System.currentTimeMillis();
        this.tests = new ArrayList<TestResult>();
    }

    @Override
    public void reportTest(TestResult result) {
        this.tests.add(result);
    }

    @Override
    public void finishReporting() {
        long time = System.currentTimeMillis() - this.startTime;
        ArrayList<TestResult> toRemove = new ArrayList<TestResult>();
        for (TestResult tr : this.tests) {
            if (!tr.isSuppressed()) continue;
            toRemove.add(tr);
        }
        this.tests.removeAll(toRemove);
        this.origStdout.println("TAP version 13");
        this.origStdout.println(String.format("1..%d", this.tests.size()));
        System.out.flush();
        try {
            this.delayedOut.flush();
        }
        catch (IOException i$) {
            // empty catch block
        }
        String testOutput = this.delayedOut.toString();
        if (testOutput.length() > 0) {
            this.origStdout.println("# Unexpected test output:");
            String[] lines = testOutput.toString().split("\n");
            if (lines.length < 100) {
                for (String line : lines) {
                    this.origStdout.println("# " + line);
                }
            } else {
                this.origStdout.println("# " + lines.length + " lines (elided for brevity)");
            }
        }
        this.origStdout.println("# Time: " + this.elapsedTimeAsString(time));
        for (int i = 0; i < this.tests.size(); ++i) {
            this.tests.get(i).renderToTAP(this.origStdout, i + 1);
        }
        this.origStdout.flush();
    }

    private String elapsedTimeAsString(long time) {
        return NumberFormat.getInstance().format((double)time / 1000.0);
    }

    @Override
    public void displayVersion(String version) {
    }

    @Override
    public void printStackTrace(Throwable e) {
    }

    @Override
    public void showClassName(Class<?> klass) {
    }

    @Override
    public void showClassOutput(String name, String output) {
    }

    @Override
    public void reportTestFailed(int numberOfTests, Throwable e, double weight, String testName) {
        if (e instanceof TestTimedOut.TimeoutException) {
            TestTimedOut.TimeoutException t = (TestTimedOut.TimeoutException)e;
            this.tests.add(t.asTestResult());
        } else if (e instanceof StackOverflow.StackOverflowException) {
            StackOverflow.StackOverflowException t = (StackOverflow.StackOverflowException)e;
            this.tests.add(t.asTestResult());
        } else {
            this.tests.add(new TestFailure(weight, testName, e));
        }
    }

    @Override
    public void findMethodError(String testname) {
        System.out.println(testname);
    }

    @Override
    public void testReport(String testCountDesc, int errorCount, String results) {
    }

    @Override
    public void fullTestReport(String testCountDesc, String results) {
    }
}

