/*
 * Decompiled with CFR 0.152.
 */
package tester.TestResults;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

public abstract class TestResult {
    public final boolean passed;
    public final boolean suppressed;
    public final String testName;
    public final String message;
    public final double weight;

    public TestResult(boolean passed, boolean suppressed, double weight, String testName, String message) {
        this.passed = passed;
        this.testName = testName;
        this.weight = weight;
        this.suppressed = suppressed;
        this.message = message;
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    public final void renderToTAP(PrintStream out, int testNum) {
        if (this.suppressed) {
            return;
        }
        if (this.passed) {
            out.printf("ok %d %s\n", testNum, this.testName);
        } else {
            out.printf("not ok %d %s\n", testNum, this.testName);
        }
        out.printf("# More information\n", new Object[0]);
        out.printf("  ---\n", new Object[0]);
        out.printf("  message: %s\n", this.escapeString(this.message));
        out.printf("  weight: %f\n", this.weight);
        this.renderToTAP(out, "  ");
        out.printf("  suppressed: false\n", new Object[0]);
        out.printf("  ...\n", new Object[0]);
    }

    protected String escapeString(String s) {
        return "\"" + s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n") + "\"";
    }

    protected List<String> renderPrintedValue(String s, String indent) {
        String[] sLines = s.split("\n");
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : sLines) {
            lines.add(indent + this.escapeString(line));
        }
        return lines;
    }

    protected void printStackTrace(PrintStream out, String indent, StackTraceElement[] stack) {
        out.printf("%sstack: [\n", indent);
        ArrayList<String> condensedStack = new ArrayList<String>();
        int count = 0;
        String cur = null;
        for (StackTraceElement ste : stack) {
            if (cur == null) {
                cur = ste.toString();
                count = 1;
                continue;
            }
            if (cur.equals(ste.toString())) {
                ++count;
                continue;
            }
            if (count == 1) {
                condensedStack.add(cur);
            } else {
                condensedStack.add(String.format("%s       <called %d times>", cur, count));
            }
            count = 1;
            cur = ste.toString();
        }
        if (count == 1) {
            condensedStack.add(cur);
        } else {
            condensedStack.add(String.format("%s       <called %d times>", cur, count));
        }
        for (String s : condensedStack) {
            out.printf("%s%s%s,\n", indent, indent, this.escapeString(s));
        }
        out.printf("%s%s]\n", indent, indent);
    }

    protected abstract void renderToTAP(PrintStream var1, String var2);
}

