/*
 * Decompiled with CFR 0.152.
 */
package tester.TestResults;

import java.io.PrintStream;
import tester.TestResults.TestResult;

public class TestTimedOut
extends TestResult {
    private final StackTraceElement[] stack;
    private final int timeout;

    public TestTimedOut(StackTraceElement[] stackTraceAtFailure, int timeout, double weight, String testName) {
        super(false, false, weight, testName, String.format("Test timed out after %d milliseconds", timeout));
        this.stack = stackTraceAtFailure;
        this.timeout = timeout;
    }

    @Override
    protected void renderToTAP(PrintStream out, String indent) {
        out.printf("%stimeout: %d\n", indent, this.timeout);
        this.printStackTrace(out, indent, this.stack);
    }

    public static class TimeoutException
    extends Throwable {
        public final StackTraceElement[] stack;
        public final int timeout;
        public final double weight;
        public final String testName;

        public TimeoutException(StackTraceElement[] stack, int timeout, double weight, String testName) {
            this.stack = stack;
            this.timeout = timeout;
            this.weight = weight;
            this.testName = testName;
        }

        public TestResult asTestResult() {
            return new TestTimedOut(this.stack, this.timeout, this.weight, this.testName);
        }
    }
}

