/*
 * Decompiled with CFR 0.152.
 */
package tester;

import edu.neu.TestWeight;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tester.DefaultReporter;
import tester.Equivalence;
import tester.ErrorReport;
import tester.IExamples;
import tester.Inspector;
import tester.OutputReporter;
import tester.Printer;
import tester.Reflector;
import tester.TestResults.StackOverflow;
import tester.TestResults.TestCorrectException;
import tester.TestResults.TestEquality;
import tester.TestResults.TestMethodInvocation;
import tester.TestResults.TestTimedOut;
import tester.Traversal;

public class Tester {
    private static String version;
    protected StringBuilder failedResults = new StringBuilder("Failed test results: \n--------------\n");
    protected StringBuilder fullTestResults = new StringBuilder("Full test results: \n-------------------\n");
    protected int numberOfTests;
    protected boolean enforceTimeouts;
    protected int errors;
    protected int warnings;
    protected String testname;
    protected double weight;
    protected Inspector inspector = new Inspector();
    protected OutputReporter outputReporter;
    protected int reportWidth = 48;

    public Tester() {
        Inspector.TOLERANCE = 0.001;
        this.numberOfTests = 0;
        this.errors = 0;
        this.warnings = 0;
        this.testname = "";
    }

    protected void runAnyTests(Object f, boolean enforceTimeouts, OutputReporter outputReporter, int outputWidth) {
        this.runAnyTests(f, false, enforceTimeouts, outputReporter, outputWidth);
    }

    protected void runAnyTests(Object f, boolean full, boolean enforceTimeouts, OutputReporter outputReporter, int outputWidth) {
        this.runAnyTests(f, full, false, enforceTimeouts, outputReporter, outputWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runAnyTests(Object f, boolean full, boolean printall, boolean enforceTimeouts, OutputReporter outputReporter, int outputWidth) {
        this.numberOfTests = 0;
        boolean failed = false;
        this.outputReporter = outputReporter;
        this.reportWidth = outputWidth;
        this.enforceTimeouts = enforceTimeouts;
        this.outputReporter.displayVersion(version);
        this.outputReporter.showClassName(f.getClass());
        if (printall) {
            this.outputReporter.showClassOutput(f.getClass().getName(), Printer.produceString(f));
        }
        Class<?>[] interfaces = f.getClass().getInterfaces();
        boolean foundInterface = false;
        for (Class<?> c : interfaces) {
            if (!c.getName().equals("tester.IExamples")) continue;
            this.runTests((IExamples)f, full, printall);
            foundInterface = true;
        }
        if (!foundInterface) {
            ArrayList<Method> testMethods = this.findTestMethods(f, "Your class does not define any method with the header\n boolean test...(Tester t)");
            if (testMethods != null && !testMethods.isEmpty()) {
                Collections.shuffle(testMethods);
                Object[] args = new Object[]{this};
                try {
                    for (Method testMethod : testMethods) {
                        try {
                            int timeout;
                            if (testMethod == null) continue;
                            Annotation[] anns = testMethod.getDeclaredAnnotations();
                            TestWeight w = testMethod.getAnnotation(TestWeight.class);
                            if (w != null) {
                                this.weight = w.weight();
                                timeout = w.timeout();
                            } else if (this.enforceTimeouts) {
                                this.weight = 1.0;
                                timeout = 60000;
                            } else {
                                this.weight = 1.0;
                                timeout = -1;
                            }
                            WaitForTest waitForTest = new WaitForTest(testMethod, f, args);
                            FutureTask<Throwable> task = new FutureTask<Throwable>(waitForTest);
                            ThreadGroup threadGroup = new ThreadGroup("FailOnTimeoutGroup");
                            Thread thread = new Thread(threadGroup, task, "Time-limited test");
                            thread.setDaemon(true);
                            thread.start();
                            waitForTest.awaitStarted();
                            Throwable throwable = this.getResult(timeout, task, thread);
                            if (throwable == null) continue;
                            throw throwable;
                        }
                        catch (Throwable e) {
                            ++this.errors;
                            ++this.numberOfTests;
                            this.outputReporter.reportTestFailed(this.numberOfTests, e, this.weight, "Unexpected exception in " + testMethod.toString() + " terminated tests early");
                            failed = true;
                        }
                    }
                }
                finally {
                    if (full) {
                        this.fullTestReport();
                    } else {
                        this.testReport();
                    }
                    this.done(failed);
                }
            } else {
                System.out.println("No test methods found.");
            }
        }
    }

    private Throwable getResult(int timeout, FutureTask<Throwable> task, Thread thread) {
        try {
            Throwable result = timeout > 0 || this.enforceTimeouts ? task.get(timeout, TimeUnit.MILLISECONDS) : task.get();
            if (result instanceof StackOverflowError) {
                return new StackOverflow.StackOverflowException(result.getStackTrace(), this.weight, this.testname);
            }
            return result;
        }
        catch (InterruptedException e) {
            return e;
        }
        catch (ExecutionException e) {
            return e.getCause();
        }
        catch (TimeoutException e) {
            return new TestTimedOut.TimeoutException(thread.getStackTrace(), timeout, this.weight, this.testname);
        }
        catch (Exception e) {
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTests(IExamples f, boolean full, boolean printall) {
        this.numberOfTests = 0;
        boolean failed = false;
        if (printall) {
            this.outputReporter.showClassOutput("Examples class", Printer.produceString(f));
        }
        try {
            this.weight = 1.0;
            f.tests(this);
        }
        catch (Throwable e) {
            ++this.errors;
            ++this.numberOfTests;
            this.outputReporter.reportTestFailed(this.numberOfTests, e, this.weight, this.testname);
            failed = true;
        }
        finally {
            if (full) {
                this.fullTestReport();
            } else {
                this.testReport();
            }
            this.done(failed);
        }
    }

    protected void done(boolean failed) {
        if (failed) {
            this.reportErrors(this.testname, "caused RuntimeException");
            System.runFinalization();
        }
    }

    protected boolean setTolerance(double epsilon) {
        Inspector.TOLERANCE = epsilon;
        return epsilon > 0.0;
    }

    public boolean same(Object obj1, Object obj2) {
        return this.inspector.isSame(obj1, obj2);
    }

    public <T> boolean checkExpect(T actual, T expected) {
        return this.checkExpect(actual, expected, "");
    }

    public <T> boolean checkExpect(T actual, T expected, String testname) {
        this.testname = testname;
        return this.report(this.inspector.exactTest() && this.inspector.isSame(actual, expected) && !this.inspector.inexactViolation(), testname, "checkExpect", actual, expected);
    }

    public <T> boolean checkInexact(T actual, T expected, double tolerance) {
        return this.checkInexact(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexact(T actual, T expected, double tolerance, String testname) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", "checkInexact", actual, expected);
        }
        if (this.isExactType(actual.getClass().getName()) || this.isExactType(expected.getClass().getName())) {
            return this.report(false, testname + "\nAttempt to make inexact comparison of " + "" + "exact primitive or wrapper data", "checkInexact", actual, expected);
        }
        return this.report(this.inspector.isSame(actual, expected), testname, "checkInexact", actual, expected);
    }

    public <T> boolean checkSet(Set<T> actual, Set<T> expected) {
        return this.checkSet(actual, expected, "");
    }

    public <T> boolean checkSet(Set<T> actual, Set<T> expected, String testname) {
        this.testname = testname;
        return this.reportIterable(this.inspector.exactTest() && this.inspector.isSameSet(actual, expected) && !this.inspector.inexactViolation(), testname, actual, expected);
    }

    public <T> boolean checkIterable(Iterable<T> actual, Iterable<T> expected) {
        return this.checkIterable(actual, expected, "");
    }

    public <T> boolean checkIterable(Iterable<T> actual, Iterable<T> expected, String testname) {
        this.testname = testname;
        return this.reportIterable(this.inspector.exactTest() && this.inspector.isSameIterable(actual, expected) && !this.inspector.inexactViolation(), testname, actual, expected);
    }

    public <T> boolean checkInexactIterable(Iterable<T> actual, Iterable<T> expected, double tolerance) {
        return this.checkInexactIterable(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexactIterable(Iterable<T> actual, Iterable<T> expected, double tolerance, String testname) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.reportIterable(false, testname + "\nProvided tolerance value was < 0", actual, expected);
        }
        this.testname = testname;
        return this.reportIterable(this.inspector.isSameIterable(actual, expected), testname, actual, expected);
    }

    public <T> boolean checkTraversal(Traversal<T> actual, Traversal<T> expected) {
        return this.checkTraversal(actual, expected, "");
    }

    public <T> boolean checkTraversal(Traversal<T> actual, Traversal<T> expected, String testname) {
        this.testname = testname;
        return this.reportTraversal(this.inspector.exactTest() && this.inspector.isSameTraversal(actual, expected) && !this.inspector.inexactViolation(), testname, actual, expected);
    }

    public <T> boolean checkInexactTraversal(Traversal<T> actual, Traversal<T> expected, double tolerance) {
        return this.checkInexactTraversal(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexactTraversal(Traversal<T> actual, Traversal<T> expected, double tolerance, String testname) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.reportTraversal(false, testname + "\nProvided tolerance value was < 0", actual, expected);
        }
        this.testname = testname;
        return this.reportTraversal(this.inspector.isSameTraversal(actual, expected), testname, actual, expected);
    }

    public <T> boolean checkFail(T actual, T expected) {
        return this.checkFail(actual, expected, "");
    }

    public <T> boolean checkFail(T actual, T expected, String testname) {
        this.testname = testname;
        return this.report(this.inspector.exactTest() && (!this.inspector.isSame(actual, expected) || this.inspector.inexactViolation()), "Failure expected: \n" + testname, "checkFail", actual, expected);
    }

    public <T> boolean checkInexactFail(T actual, T expected, double tolerance) {
        return this.checkInexactFail(actual, expected, tolerance, "");
    }

    public <T> boolean checkInexactFail(T actual, T expected, double tolerance, String testname) {
        if (tolerance < 0.0) {
            return this.report(true, testname + " Failure expected: \n" + "\n Test failed because the provided tolerance is < 0", "checkInexactFail", actual, expected);
        }
        if (this.isExactType(actual.getClass().getName()) || this.isExactType(expected.getClass().getName())) {
            return this.report(true, testname + " Failure expected: \n" + "\nTest failed because we cannot make inexact comparison of " + "exact primitive or wrapper data", "checkInexactFail", actual, expected);
        }
        this.setTolerance(tolerance);
        this.testname = testname;
        return this.report(!this.inspector.isSame(actual, expected), "Failure expected: \n" + testname, "checkInexactFail", actual, expected);
    }

    public <T> boolean checkException(Exception e, T object, String method, Object ... args) {
        return this.checkException("", e, object, method, args);
    }

    public <T> boolean checkException(String testname, Exception e, T object, String method, Object ... args) {
        return this.checkPrivateException(testname, e, object, method, args);
    }

    private <T> boolean checkPrivateException(String testname, Exception e, T object, String method, Object ... args) {
        this.testname = testname;
        int length = args != null ? args.length : 0;
        Class[] parameters = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameters[i] = args[i] == null ? null : args[i].getClass();
        }
        Class<?> exceptClass = e.getClass();
        String exceptName = exceptClass.getName();
        String exceptMessage = e.getMessage();
        String trace = this.getStackTrace();
        try {
            Method meth = this.findMethod(object, method, parameters);
            if (meth == null) {
                this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Expected an exception in the method, but no such method was found", object.getClass().getName() + "#" + method, "<none>", "", exceptName, exceptMessage));
                throw new NoSuchMethodException("Method " + method + " not found");
            }
            Reflector.ensureIsAccessible(meth);
            Object result = meth.invoke(object, args);
            this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Excepted an exception in the method, but no exception was thrown", object.getClass().getName() + "#" + method, "<none>", "", exceptName, exceptMessage));
            if (result == null) {
                return this.reportMessage(false, testname, "\n invocation did not throw any exception \n  method name: " + meth.getName() + "\n  object class: " + object.getClass().getName() + "\n  result: void" + ": " + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
            }
            return this.reportMessage(false, testname, "\n invocation did not throw any exception \n  method name: " + meth.getName() + "\n  object class: " + object.getClass().getName() + "\n  result: " + result.getClass().getName() + ": " + Printer.produceString(result) + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
        }
        catch (Throwable exception) {
            String excMessage;
            String excName;
            if (exception.getCause() != null) {
                excName = exception.getCause().getClass().getName();
                excMessage = exception.getCause().getMessage();
            } else {
                excName = exception.getClass().getName();
                excMessage = exception.getMessage();
            }
            if (excName.equals(exceptName)) {
                if (exceptMessage == null && excMessage == null || excMessage != null && excMessage.equals(exceptMessage)) {
                    this.outputReporter.reportTest(new TestCorrectException(true, false, this.weight, testname, "Intended exception and message", object.getClass().getName() + "#" + method, excName, excMessage, exceptName, exceptMessage));
                    return this.reportSuccess(testname, "\n correct exception: \n class: " + exceptName + "\n correct message: " + exceptMessage + "\n    after invoking the method " + method + "\n    by an object in the class: " + object.getClass().getName() + "\n    object value was: \n" + Printer.produceString(object));
                }
                this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Incorrect method exception message", object.getClass().getName() + "#" + method, excName, excMessage, exceptName, exceptMessage));
                return this.reportErrors(testname, "\n correct exception: \n class: " + exceptName + "\n incorrect message: \n" + "\n message produced: " + excMessage + "\n message expected: " + exceptMessage + "\n    after invoking the method " + method + "\n    by an object in the class: " + object.getClass().getName() + "\n    object value was: \n" + Printer.produceString(object) + "\n\n" + trace + "\n");
            }
            this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Incorrect method exception type", object.getClass().getName() + "#" + method, excName, excMessage, exceptName, exceptMessage));
            return this.reportErrors(testname, "\n incorrect exception was thrown: \n exception thrown:   " + excName + "\n with the message:   " + excMessage + "\n exception expected: " + exceptName + "\n   with the message: " + exceptMessage + "\n   after invoking the method " + method + "\n   by an object in the class: " + object.getClass().getName() + "\n   object value was: \n" + Printer.produceString(object) + "\n\n" + trace + "\n");
        }
    }

    public <T> boolean checkConstructorException(Exception e, String className, Object ... args) {
        return this.checkConstructorException("", e, className, args);
    }

    public <T> boolean checkConstructorException(String testname, Exception e, String className, Object ... args) {
        return this.checkPrivateConstructorException(testname, e, className, args);
    }

    private <T> boolean checkPrivateConstructorException(String testname, Exception e, String className, Object ... args) {
        this.testname = testname;
        int length = args != null ? args.length : 0;
        Class[] parameters = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameters[i] = args[i] != null ? args[i].getClass() : null;
        }
        Class<?> exceptClass = e.getClass();
        String exceptName = exceptClass.getName();
        String exceptMessage = e.getMessage();
        String trace = this.getStackTrace();
        try {
            Class<?> objectClass = Reflector.classForName(className);
            Constructor<?> constr = null;
            Constructor<?>[] constructors = objectClass.getDeclaredConstructors();
            for (int i = 0; i < Array.getLength(constructors); ++i) {
                if (!this.matchParams(parameters, constructors[i].getParameterTypes())) continue;
                constr = constructors[i];
                break;
            }
            if (constr == null) {
                this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Expected an exception in the constructor, but found no such constructor", className, "<none>", "", exceptName, exceptMessage));
                throw new NoSuchMethodException("Constructor for the class " + className + " with the given arguments not found");
            }
            Reflector.ensureIsAccessible(constr);
            Object result = constr.newInstance(args);
            this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Intended constructor exception not thrown", className, "<none>", "", exceptName, exceptMessage));
            if (result == null) {
                return this.reportMessage(false, testname, "\n constructor invocation for the class " + className + " did not throw any exception " + "\n  result: void" + ": " + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
            }
            return this.reportMessage(false, testname, "\n constructor invocation for the class " + className + " did not throw any exception " + "\n  result: " + result.getClass().getName() + ": " + Printer.produceString(result) + "\n  expected exception was: \n    class: " + exceptName + "\n    message: " + exceptMessage);
        }
        catch (Throwable exception) {
            String excMessage;
            String excName;
            if (exception.getCause() != null) {
                excName = exception.getCause().getClass().getName();
                excMessage = exception.getCause().getMessage();
            } else {
                excName = exception.getClass().getName();
                excMessage = exception.getMessage();
            }
            if (excName.equals(exceptName)) {
                if (exceptMessage == null && excMessage == null || excMessage != null && excMessage.equals(exceptMessage)) {
                    this.outputReporter.reportTest(new TestCorrectException(true, false, this.weight, testname, "Intended constructor exception", className, exceptName, exceptMessage, exceptName, exceptMessage));
                    return this.reportSuccess(testname, "\n correct exception: \n class: " + exceptName + "\n correct message: " + exceptMessage + "\n" + "\n after invoking the constructor for the class " + className);
                }
                this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Incorrect constructor exception message", className, excName, excMessage, exceptName, exceptMessage));
                return this.reportErrors(testname, "\n correct exception: \n class: " + exceptName + "\n incorrect message: \n" + "\n message produced: " + excMessage + "\n message expected: " + exceptMessage + "\n after invoking the constructor for the class " + className + "\n\n" + trace + "\n");
            }
            this.outputReporter.reportTest(new TestCorrectException(false, false, this.weight, testname, "Incorrect constructor exception type", className, excName, excMessage, exceptName, exceptMessage));
            return this.reportErrors(testname, "\n incorrect exception was thrown: \n exception produced: " + excName + "\n       with message: " + excMessage + "\n exception expected: " + exceptName + "\n       with message: " + exceptMessage + "\n after invoking the constructor for the class " + className + "\n\n" + trace + "\n");
        }
    }

    public <T> boolean checkMethod(Object expected, T object, String method, Object ... args) {
        return this.checkMethod("", expected, object, method, args);
    }

    public <T> boolean checkMethod(String testname, Object expected, T object, String method, Object ... args) {
        return this.inspector.exactTest() && this.checkPrivateMethod(testname, "checkMethod", expected, object, method, args, false);
    }

    public <T> boolean checkInexactMethod(Object expected, double tolerance, T object, String method, Object ... args) {
        return this.checkInexactMethod("", expected, tolerance, object, method, args);
    }

    public <T> boolean checkInexactMethod(String testname, Object expected, double tolerance, T object, String method, Object ... args) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.reportErrors(testname + "\nProvided tolerance value was < 0", "\n Inexact method invocation test ");
        }
        return this.checkPrivateMethod(testname, "checkInexactMethod", expected, object, method, args, true);
    }

    private <T> boolean checkPrivateMethod(String testname, String testType, Object expected, T object, String method, Object[] args, boolean inexact) {
        ArrayList<String> argsList;
        this.testname = testname;
        int length = Array.getLength(args);
        Class[] parameters = new Class[length];
        for (int i = 0; i < length; ++i) {
            parameters[i] = args[i].getClass();
        }
        ArrayList<String> parlist = new ArrayList<String>();
        for (Class parameter : parameters) {
            parlist.add(parameter.getName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < parlist.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append((String)parlist.get(i));
        }
        sb.append(")");
        String parlistAsString = sb.toString();
        try {
            Method meth = this.findMethod(object, method, parameters);
            if (meth == null) {
                argsList = new ArrayList(args.length);
                for (Object arg : args) {
                    argsList.add(Printer.produceString(args));
                }
                this.outputReporter.reportTest(new TestMethodInvocation(false, false, this.weight, testname, testType + " could not invoke the given method", object.getClass().getName() + "#" + method, parlist, argsList, Printer.produceString(expected)));
                return this.reportMessage(false, testname + "\nNo method with the name " + method + " found\n", "Failed to invoke the method " + object.getClass().getName() + "." + method + parlistAsString + Printer.produceString(expected));
            }
            Reflector.ensureIsAccessible(meth);
            String testmessage = testname + "\n" + Printer.produceString(object) + "\n invoked method " + method + " in the class " + object.getClass().getName() + "\n with arguments " + this.makeArglist(args) + ")\n";
            if (inexact) {
                return this.checkInexact(meth.invoke(object, args), expected, Inspector.TOLERANCE, testmessage);
            }
            return this.checkExpect(meth.invoke(object, args), expected, testmessage);
        }
        catch (Throwable exception) {
            argsList = new ArrayList<String>(args.length);
            for (Object arg : args) {
                argsList.add(Printer.produceString(args));
            }
            this.outputReporter.reportTest(new TestMethodInvocation(false, false, this.weight, testname, testType + " threw an exception while invoking the method", object.getClass().getName() + "#" + method, parlist, argsList, Printer.produceString(expected)));
            String testmessage = testname + "\n" + Printer.produceString(object) + "\n invoked method " + method + " in the class " + object.getClass().getName() + "\n with arguments " + this.makeArglist(args) + ")\n";
            boolean result = this.reportMessage(false, testmessage + "\nthrew an exception ", Printer.produceString(object) + Printer.produceString(args));
            this.outputReporter.printStackTrace(exception);
            return result;
        }
    }

    private String makeArglist(Object ... args) {
        String arglist = "(";
        for (Object o : args) {
            arglist = arglist.concat(Printer.produceString(o) + ",\n");
        }
        if (arglist.length() > 1) {
            arglist = arglist.substring(0, arglist.length() - 2);
        }
        return arglist;
    }

    @SafeVarargs
    public final <T> boolean checkOneOf(T actual, T ... expected) {
        return this.checkOneOf("", actual, expected);
    }

    @SafeVarargs
    public final <T> boolean checkOneOf(String testname, T actual, T ... expected) {
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i]) || this.inspector.inexactViolation()) continue;
            return this.report(true, testname, "checkOneOf", actual, expected[i]);
        }
        return this.report(false, testname + "\nNo matching value found " + "among the list of expected values", "checkOneOf", actual, expected);
    }

    @SafeVarargs
    public final <T> boolean checkInexactOneOf(double tolerance, T actual, T ... expected) {
        return this.checkInexactOneOf("", tolerance, actual, expected);
    }

    @SafeVarargs
    public final <T> boolean checkInexactOneOf(String testname, double tolerance, T actual, T ... expected) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", "checkInexactOneOf", actual, expected);
        }
        this.testname = testname;
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i])) continue;
            return this.report(true, testname, "checkInexactOneOf", actual, expected[i]);
        }
        return this.report(false, testname + "\nNo matching value found " + "among the list of expected values", "checkInexactOneOf", actual, expected);
    }

    @SafeVarargs
    public final <T> boolean checkNoneOf(T actual, T ... expected) {
        return this.checkNoneOf(actual, expected, "");
    }

    @SafeVarargs
    public final <T> boolean checkNoneOf(String testname, T actual, T ... expected) {
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i]) || this.inspector.inexactViolation()) continue;
            return this.report(false, "Matching value found in none-of test\n" + testname, "checkNoneOf", actual, expected[i]);
        }
        return this.report(true, testname + "\nNo matching value found among the list of excluded values", "checkNoneOf", actual, expected);
    }

    @SafeVarargs
    public final <T> boolean checkInexactNoneOf(double tolerance, T actual, T ... expected) {
        return this.checkInexactNoneOf(tolerance, actual, expected, "");
    }

    @SafeVarargs
    public final <T> boolean checkInexactNoneOf(String testname, double tolerance, T actual, T ... expected) {
        if (this.inspector.inexactTest(tolerance)) {
            return this.report(false, testname + "\nProvided tolerance value was < 0", "checkInexactNoneOf", actual, expected);
        }
        this.testname = testname;
        for (int i = 0; i < Array.getLength(expected); ++i) {
            if (!this.inspector.isSame(actual, expected[i])) continue;
            return this.report(false, "Matching value found in none-of test\n" + testname, "checkInexactNoneOf", actual, expected[i]);
        }
        return this.report(true, testname + "\nNo matching value found among the list of excluded values", "checkInexactNoneOf", actual, expected);
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high) {
        return this.checkNumRange(actual, low, high, "");
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high, String testname) {
        return this.checkNumRange(actual, low, high, true, false, testname);
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high, boolean lowIncl, boolean highIncl) {
        return this.checkNumRange(actual, low, high, lowIncl, highIncl, "");
    }

    public <T> boolean checkNumRange(Number actual, Number low, Number high, boolean lowIncl, boolean highIncl, String testname) {
        boolean belowHigh;
        Inspector.INEXACT_COMPARED = false;
        this.testname = testname;
        boolean within = true;
        boolean aboveLow = Double.valueOf(actual.doubleValue()).compareTo(low.doubleValue()) > 0;
        boolean bl = belowHigh = Double.valueOf(actual.doubleValue()).compareTo(high.doubleValue()) < 0;
        if (lowIncl) {
            boolean bl2 = aboveLow = aboveLow || Double.valueOf(actual.doubleValue()).compareTo(low.doubleValue()) == 0;
        }
        if (highIncl) {
            belowHigh = belowHigh || Double.valueOf(actual.doubleValue()).compareTo(high.doubleValue()) == 0;
        }
        boolean bl3 = within = aboveLow && belowHigh;
        if (within) {
            return this.report(within, testname, "checkNumRange", actual, low, high);
        }
        return this.report(within, testname + "\nActual value is not within the [low high) range.", "checkNumRange", actual, low, high);
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high) {
        return this.checkRange(actual, low, high, "");
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high, String testname) {
        return this.checkRange(actual, low, high, true, false, testname);
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high, boolean lowIncl, boolean highIncl) {
        return this.checkRange(actual, low, high, lowIncl, highIncl, "");
    }

    public <T> boolean checkRange(Comparable<T> actual, T low, T high, boolean lowIncl, boolean highIncl, String testname) {
        Inspector.INEXACT_COMPARED = false;
        this.testname = testname;
        boolean within = true;
        boolean aboveLow = true;
        boolean belowHigh = true;
        String ls = "(";
        String hs = ")";
        if (lowIncl) {
            aboveLow = actual.compareTo(low) >= 0;
            ls = "[";
        } else {
            boolean bl = aboveLow = actual.compareTo(low) > 0;
        }
        if (highIncl) {
            belowHigh = actual.compareTo(high) <= 0;
            hs = "]";
        } else {
            belowHigh = actual.compareTo(high) < 0;
        }
        boolean bl = within = aboveLow && belowHigh;
        if (within) {
            return this.report(within, testname, "checkRange", actual, low, high);
        }
        return this.report(within, testname + "\nActual value is not within the " + ls + "low high" + hs + " range.", "checkRange", actual, low, high);
    }

    public <T> boolean checkRange(T actual, T low, T high, Comparator<T> comp, String testname) {
        return this.checkRange(actual, low, high, true, false, comp, testname);
    }

    public <T> boolean checkRange(T actual, T low, T high, Comparator<T> comp) {
        return this.checkRange(actual, low, high, true, false, comp, "");
    }

    public <T> boolean checkRange(T actual, T low, T high, boolean lowIncl, boolean highIncl, Comparator<T> comp) {
        return this.checkRange(actual, low, high, lowIncl, highIncl, comp, "");
    }

    public <T> boolean checkRange(T actual, T low, T high, boolean lowIncl, boolean highIncl, Comparator<T> comp, String testname) {
        Inspector.INEXACT_COMPARED = false;
        this.testname = testname;
        boolean within = true;
        boolean aboveLow = true;
        boolean belowHigh = true;
        String ls = "(";
        String hs = ")";
        if (lowIncl) {
            aboveLow = comp.compare(actual, low) >= 0;
            ls = "[";
        } else {
            boolean bl = aboveLow = comp.compare(actual, low) > 0;
        }
        if (highIncl) {
            belowHigh = comp.compare(actual, high) <= 0;
            hs = "]";
        } else {
            belowHigh = comp.compare(actual, high) < 0;
        }
        boolean bl = within = aboveLow && belowHigh;
        if (within) {
            return this.report(within, testname, "checkRange", actual, low, high);
        }
        return this.report(within, testname + "\nActual value is not within the " + ls + "low high" + hs + " range.", "checkRange", actual, low, high);
    }

    public <T> boolean checkEquivalent(T obj1, T obj2, Equivalence<T> equiv) {
        return this.checkEquivalent(obj1, obj2, equiv, "");
    }

    public <T> boolean checkEquivalent(T obj1, T obj2, Equivalence<T> equiv, String testname) {
        this.testname = "Equivalence test: \n" + testname;
        return this.report(equiv.equivalent(obj1, obj2), testname, "checkEquivalent", obj1, obj2);
    }

    private <T> Method findMethod(T object, String method, Class<?>[] parameters) {
        Method[] allMethods = this.findAllMethods(object.getClass());
        ArrayList<Method> allNamed = new ArrayList<Method>();
        for (Method elt : allMethods) {
            if (!elt.getName().equals(method)) continue;
            allNamed.add(elt);
        }
        if (allNamed.size() > 0) {
            for (Method m : allNamed) {
                if (!this.matchParams(parameters, m.getParameterTypes())) continue;
                return m;
            }
            this.testname = this.testname + "\nNo method with the name " + method + " had a matching argument list\n";
            this.outputReporter.findMethodError(this.testname);
            return null;
        }
        this.testname = this.testname + "\nNo method with the name " + method + " found\n";
        this.outputReporter.findMethodError(this.testname);
        return null;
    }

    private <T> ArrayList<Method> findTestMethods(T object, String testname) {
        Method[] allMethods = this.findAllMethods(object.getClass());
        ArrayList<Method> allNamed = new ArrayList<Method>();
        Class[] testerParam = new Class[]{this.getClass()};
        for (Method method : allMethods) {
            if (!method.getName().startsWith("test") || !this.matchParams(method.getParameterTypes(), testerParam)) continue;
            allNamed.add(method);
            Reflector.ensureIsAccessible(method);
        }
        testname = allNamed.size() > 0 ? testname + "Found " + allNamed.size() + " test methods" : testname + "\nNo method with the name test..." + " found in the class " + object.getClass().getName() + "\n";
        return allNamed;
    }

    private Method[] findAllMethods(Class<?> c) {
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class<?> classToSurvey = c; classToSurvey != null && classToSurvey != Object.class; classToSurvey = classToSurvey.getSuperclass()) {
            Method[] allMethods;
            for (Method m : allMethods = classToSurvey.getDeclaredMethods()) {
                Reflector.ensureIsAccessible(m);
                list.add(m);
            }
        }
        return list.toArray(new Method[0]);
    }

    private boolean matchParams(Class<?>[] parInput, Class<?>[] parDefined) {
        if (Array.getLength(parInput) != Array.getLength(parDefined)) {
            return false;
        }
        if (Array.getLength(parInput) == 0) {
            return true;
        }
        for (int i = 0; i < Array.getLength(parInput); ++i) {
            if (this.matchPair(parInput[i], parDefined[i])) continue;
            return false;
        }
        return true;
    }

    private boolean matchPair(Class<?> parInput, Class<?> parDefined) {
        String def;
        if (parInput == null) {
            return parDefined != null && !parDefined.isPrimitive();
        }
        String in = parInput.getName();
        if (in.equals(def = parDefined.getName())) {
            return true;
        }
        if (def.equals("java.lang.Object")) {
            return true;
        }
        if (in.equals("java.lang.String") || def.equals("java.lang.String")) {
            return false;
        }
        return !(Inspector.isWrapperClass(def) || Inspector.isWrapperClass(in) ? !this.isWrapperMatch(in, def) : !parDefined.isAssignableFrom(parInput));
    }

    private boolean isWrapperMatch(String in, String def) {
        if (def.equals("java.lang.Integer") && in.equals("int")) {
            return true;
        }
        if (def.equals("java.lang.Short") && in.equals("short")) {
            return true;
        }
        if (def.equals("java.lang.Long") && in.equals("long")) {
            return true;
        }
        if (def.equals("java.lang.Byte") && in.equals("byte")) {
            return true;
        }
        if (def.equals("java.lang.Character") && in.equals("char")) {
            return true;
        }
        if (def.equals("java.lang.Double") && in.equals("double")) {
            return true;
        }
        if (def.equals("java.lang.Float") && in.equals("float")) {
            return true;
        }
        if (def.equals("java.lang.Boolean") && in.equals("boolean")) {
            return true;
        }
        if (def.equals("int") && in.equals("java.lang.Integer")) {
            return true;
        }
        if (def.equals("short") && in.equals("java.lang.Short")) {
            return true;
        }
        if (def.equals("long") && in.equals("java.lang.Long")) {
            return true;
        }
        if (def.equals("byte") && in.equals("java.lang.Byte")) {
            return true;
        }
        if (def.equals("char") && in.equals("java.lang.Character")) {
            return true;
        }
        if (def.equals("double") && in.equals("java.lang.Double")) {
            return true;
        }
        if (def.equals("float") && in.equals("java.lang.Float")) {
            return true;
        }
        if (def.equals("boolean") && in.equals("java.lang.Boolean")) {
            return true;
        }
        if (def.equals("java.lang.Integer") && in.equals("java.lang.Integer")) {
            return true;
        }
        if (def.equals("java.lang.Short") && in.equals("java.lang.Short")) {
            return true;
        }
        if (def.equals("java.lang.Long") && in.equals("java.lang.Long")) {
            return true;
        }
        if (def.equals("java.lang.Byte") && in.equals("java.lang.Byte")) {
            return true;
        }
        if (def.equals("java.lang.Character") && in.equals("java.lang.Character")) {
            return true;
        }
        if (def.equals("java.lang.Double") && in.equals("java.lang.Double")) {
            return true;
        }
        if (def.equals("java.lang.Float") && in.equals("java.lang.Float")) {
            return true;
        }
        return def.equals("java.lang.Boolean") && in.equals("java.lang.Boolean");
    }

    private boolean isExactType(String in) {
        return in.equals("java.lang.Integer") || in.equals("int") || in.equals("java.lang.Short") || in.equals("short") || in.equals("java.lang.Long") || in.equals("long") || in.equals("java.lang.Byte") || in.equals("byte") || in.equals("java.lang.Character") || in.equals("char") || in.equals("java.lang.Boolean") || in.equals("boolean");
    }

    private boolean report(boolean success, String testname, String testType, Object actual, Object expected) {
        String actString = Printer.produceString(actual, false);
        String expString = Printer.produceString(expected, true);
        String result = Printer.combineActualExpected("actual:", "expected:", this.reportWidth) + "\n" + Printer.combineActualExpected(actString, expString, this.reportWidth);
        this.outputReporter.reportTest(new TestEquality(success, false, this.weight, testType, testname, actString, expString));
        if (success) {
            return this.reportSuccess(testname, result);
        }
        String trace = this.getStackTrace();
        return this.reportErrors(testname + "\n" + trace, result);
    }

    private boolean reportMessage(boolean success, String testname, String result) {
        if (success) {
            return this.reportSuccess(testname, result);
        }
        String trace = this.getStackTrace();
        return this.reportErrors(testname + "\n" + trace, result);
    }

    private <T> boolean reportIterable(boolean success, String testname, Iterable<T> actual, Iterable<T> expected) {
        String actString = Printer.produceString(actual, false);
        String expString = Printer.produceString(expected, true);
        String result = Printer.combineActualExpected("actual:", "expected:", this.reportWidth) + "\n" + Printer.combineActualExpected(actString, expString, this.reportWidth);
        if (success) {
            return this.reportSuccess(testname, result);
        }
        String trace = this.getStackTrace();
        return this.reportErrors(testname + "\n" + trace, result);
    }

    private <T> boolean reportTraversal(boolean success, String testname, Traversal<T> actual, Traversal<T> expected) {
        String actString = Printer.produceTraversalStrings(actual, false);
        String expString = Printer.produceTraversalStrings(expected, true);
        String result = Printer.combineActualExpected("actual:", "expected:", this.reportWidth) + "\n" + Printer.combineActualExpected(actString, expString, this.reportWidth);
        if (success) {
            return this.reportSuccess(testname, result);
        }
        String trace = this.getStackTrace();
        return this.reportErrors(testname + "\n" + trace, result);
    }

    private boolean report(boolean success, String testname, String message, Object actual, Object low, Object high) {
        if (success) {
            return this.reportSuccess(testname, message, actual, low, high);
        }
        String trace = this.getStackTrace();
        return this.reportErrors(testname + "\n" + trace, actual, low, high);
    }

    private boolean reportErrors(String testname, String result) {
        return this.addError("Error in test number " + (this.numberOfTests + 1) + "\n" + testname + this.insertWarning() + result + "\n");
    }

    private boolean reportErrors(String testname, Object actual, Object low, Object high) {
        return this.addError("Error in range test number " + (this.numberOfTests + 1) + "\n" + testname + "\n" + this.insertWarning() + "actual:    " + Printer.produceString(actual) + "\n" + "low:       " + Printer.produceString(low) + "\n" + "high:      " + Printer.produceString(high) + "\n");
    }

    private String getStackTrace() {
        try {
            throw new ErrorReport("Error trace:");
        }
        catch (ErrorReport e) {
            StackTraceElement[] ste = e.getStackTrace();
            int length = Array.getLength(ste);
            StackTraceElement[] tmpSTE = new StackTraceElement[length];
            int ui = 0;
            for (int i = 3; i < length; ++i) {
                String cname = ste[i].getClassName();
                if (cname.startsWith("tester.") || cname.startsWith("sun.reflect") || cname.startsWith("java.lang") || cname.startsWith("bluej") || cname.startsWith("__SHELL")) continue;
                tmpSTE[ui] = ste[i];
                ++ui;
            }
            StackTraceElement[] userSTE = new StackTraceElement[ui];
            for (int i = 0; i < ui; ++i) {
                userSTE[i] = tmpSTE[i];
            }
            e.setStackTrace(userSTE);
            StringWriter writer = new StringWriter();
            PrintWriter printwriter = new PrintWriter(writer);
            e.printStackTrace(printwriter);
            return writer.toString();
        }
    }

    private boolean reportSuccess(String testname, String result) {
        return this.addSuccess("Success in the test number " + (this.numberOfTests + 1) + "\n" + testname + "\n" + this.insertWarning() + result + "\n");
    }

    private boolean reportSuccess(String testname, String message, Object actual, Object low, Object high) {
        return this.addSuccess("Success in the range test number " + (this.numberOfTests + 1) + "\n" + testname + "\n" + this.insertWarning() + "actual:   " + Printer.produceString(actual) + "\n" + "low:      " + Printer.produceString(low) + "\n" + "high:     " + Printer.produceString(high) + "\n");
    }

    private String insertWarning() {
        if (Inspector.INEXACT_COMPARED) {
            ++this.warnings;
            return "The comparison involved inexact numbers with relative tolerance " + Inspector.TOLERANCE + "\n";
        }
        return "";
    }

    private boolean addSuccess(String testResult) {
        ++this.numberOfTests;
        this.fullTestResults = this.fullTestResults.append("\n" + testResult);
        return true;
    }

    private boolean addError(String testResult) {
        ++this.numberOfTests;
        ++this.errors;
        this.failedResults = this.failedResults.append("\n" + testResult);
        this.fullTestResults = this.fullTestResults.append("\n" + testResult);
        return false;
    }

    private String testCount() {
        String tCount = "";
        if (this.numberOfTests == 1) {
            tCount = "\nRan 1 test.\n";
        } else if (this.numberOfTests > 1) {
            tCount = "\nRan " + this.numberOfTests + " tests.\n";
        }
        if (this.errors == 0) {
            tCount = tCount + "All tests passed.\n";
        }
        if (this.errors == 1) {
            tCount = tCount + "1 test failed.\n";
        } else if (this.errors > 1) {
            tCount = tCount + this.errors + " tests failed.\n";
        }
        if (this.warnings == 0) {
            tCount = tCount + "\n";
        }
        if (this.warnings == 1) {
            tCount = tCount + "Issued 1 warning of inexact comparison.\n\n";
        } else if (this.warnings > 1) {
            tCount = tCount + "Issued " + this.warnings + " warnings of inexact comparison.\n\n";
        }
        return tCount;
    }

    protected void testReport() {
        this.outputReporter.testReport(this.testCount(), this.errors, this.failedResults.toString());
    }

    protected void fullTestReport() {
        this.outputReporter.fullTestReport(this.testCount(), this.fullTestResults.toString());
    }

    public static void run(Object obj, OutputReporter outputReporter, int outputWidth) {
        Tester t = new Tester();
        t.runAnyTests(obj, false, true, outputReporter, outputWidth);
    }

    public static void runFullReport(OutputReporter outputReporter, int outputWidth, Object ... objs) {
        Tester t = new Tester();
        if (objs != null) {
            for (Object obj : objs) {
                t.runAnyTests(obj, true, true, outputReporter, outputWidth);
            }
        }
    }

    public static void runReport(Object obj, boolean full, boolean printAll) {
        Tester.runReport(obj, full, printAll, new DefaultReporter(), 48);
    }

    public static void runReport(Object obj, boolean full, boolean printall, OutputReporter outputReporter, int outputWidth) {
        Tester t = new Tester();
        t.runAnyTests(obj, full, printall, outputReporter, outputWidth);
    }

    public static void runReports(boolean full, boolean printall, OutputReporter outputReporter, int outputWidth, Object ... objs) {
        Tester t = new Tester();
        if (objs != null) {
            for (Object obj : objs) {
                t.runAnyTests(obj, full, printall, outputReporter, outputWidth);
            }
        }
    }

    static {
        try {
            String line;
            InputStream inputStream = Tester.class.getClassLoader().getResourceAsStream("META-INF/maven/ccs.neu.edu/tester/pom.xml");
            BufferedReader br = inputStream == null ? new BufferedReader(new FileReader(new File("pom.xml"))) : new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line.trim());
            }
            Pattern p = Pattern.compile("<version>(.*?)</version>");
            Matcher m = p.matcher(sb);
            m.find();
            version = "Tester Prima v." + m.group(1) + "\n-----------------------------------";
        }
        catch (Exception e) {
            System.out.println("** Failed to read tester version from pom.xml file. **");
            e.printStackTrace();
        }
    }

    private class WaitForTest
    implements Callable<Throwable> {
        private final CountDownLatch startLatch = new CountDownLatch(1);
        private final Method testMethod;
        private final Object f;
        private final Object[] args;

        public WaitForTest(Method testMethod, Object f, Object[] args) {
            this.testMethod = testMethod;
            this.f = f;
            this.args = args;
        }

        @Override
        public Throwable call() throws Exception {
            try {
                this.startLatch.countDown();
                this.testMethod.invoke(this.f, this.args);
            }
            catch (InvocationTargetException e) {
                return e.getTargetException();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable e) {
                return e;
            }
            return null;
        }

        public void awaitStarted() throws InterruptedException {
            this.startLatch.await();
        }
    }
}

