/*
 * Decompiled with CFR 0.152.
 */
package tester;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import tester.Reflector;

public class Utils {
    public static Set<Class<?>> getClassesInPackage(String packageName) {
        HashSet classes = new HashSet();
        String packageNameSlashed = "/" + packageName.replace(".", "/");
        URL directoryURL = Thread.currentThread().getContextClassLoader().getResource(packageNameSlashed);
        if (directoryURL == null) {
            return classes;
        }
        String directoryString = directoryURL.getFile();
        if (directoryString == null) {
            return classes;
        }
        File directory = new File(directoryString);
        if (directory.exists()) {
            String[] files;
            for (String fileName : files = directory.list()) {
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.length() - 6);
                try {
                    classes.add(Reflector.classForName(packageName + "." + fileName));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return classes;
    }

    public static Set<Class<?>> getConcreteDescendentsInSamePackage(Class<?> parentType) {
        Set<Class<?>> classes = Utils.getClassesInPackage(parentType.getPackage().getName());
        Class<?> c = null;
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            if (!Utils.isConcrete(c)) {
                it.remove();
            } else {
                Object obj = Utils.getDummyObject(c);
                if (!parentType.isInstance(obj)) {
                    it.remove();
                }
            }
            c = it.next();
        }
        return classes;
    }

    public static Object getDummyObject(Class<?> cls) {
        Object obj = null;
        try {
            Constructor<?> ctor = cls.getDeclaredConstructor(new Class[0]);
            Reflector.ensureIsAccessible(ctor);
            obj = ctor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e1) {
            Constructor<?> ctor = cls.getConstructors()[0];
            Class<?>[] paramTypes = ctor.getParameterTypes();
            ArrayList<Object> params = new ArrayList<Object>();
            for (Class<?> paramType : paramTypes) {
                params.add(paramType.isPrimitive() ? Utils.getTypeDefaultValue(paramType.getName()) : null);
            }
            try {
                obj = ctor.newInstance(params.toArray());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Object getTypeDefaultValue(String typeName) {
        if (typeName.equals("byte")) {
            return 0;
        }
        if (typeName.equals("short")) {
            return 0;
        }
        if (typeName.equals("int")) {
            return 0;
        }
        if (typeName.equals("long")) {
            return 0L;
        }
        if (typeName.equals("char")) {
            return Character.valueOf('\u0000');
        }
        if (typeName.equals("float")) {
            return Float.valueOf(0.0f);
        }
        if (typeName.equals("double")) {
            return 0.0;
        }
        if (typeName.equals("boolean")) {
            return false;
        }
        throw new IllegalArgumentException("Not primitive type : " + typeName);
    }

    public static boolean isConcrete(Class<?> type) {
        int modifiers = type.getModifiers();
        return !Modifier.isInterface(modifiers) && !Modifier.isAbstract(modifiers);
    }
}

