#include "utils.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>

void student_loop();
void teacher_loop();
void admin_loop();

// Create a directory if it does not exist
int ensure_dir(const char* path) {
    DIR* dir = opendir(path);
    struct stat ss;
    if (stat(path, &ss)) {
        if (errno == ENOENT) {
            return mkdir(path, 0755);
        }
        else {
            return 1;
        }
    }
    return 0;
}

#define ENSURE_OR_FAIL(d) if (ensure_dir(d)) { printf("failed to ensure %s (%d)\n", d, errno); return 1; }
// Initialize required directories of gradebook
int init_dirs() {
    ENSURE_OR_FAIL("data")
    ENSURE_OR_FAIL("data/private")
    return 0;
}

int init_admin_cred() {
    FILE* fd = fopen(ADMIN_FILE, "r");
    if (fd != NULL) {
        return fclose(fd);
    }
    if (errno == ENOENT) {
        fd = fopen(ADMIN_FILE, "w");
        if (fd == NULL) {
            return 1;
        }
        fprintf(fd, "change.this.or.no.points.kidding");
        return fclose(fd);
    }
    return 1;
}

int main() {
    srand(time(NULL));

    if (init_dirs()) {
        printf("init_dirs() failed\n");
        return 1;
    }
    if (init_admin_cred()) {
        printf("init_admin_cred() failed\n");
        return 1;
    }
    
    char* input = prompt_until_valid(VT_MODE, "Login or signup: ");
    if (strcmp(input, "login") == 0) {
        char* id = prompt_until_valid(VT_ID, "Id: ");
        char* password = prompt_until_valid(VT_PASSWORD, "Password: ");
        if (rand() % 2 == 0) {
            student_loop();
        }
        else {
            teacher_loop();
        }
    }
    else {
        admin_loop();
    }

    return 0;
}