#include "utils.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

// NOTE: You MUST read through the code if you decide to use it
//       The provided code is NOT bug-free

// Prompt user input, va_list version
char* vprompt(const char* format, va_list args) {
    char* buf;
    int length;
    int start;
    int end;
    
    vprintf (format, args);
    buf = (char*) malloc(100);
    if (fgets(buf, 10000, stdin) == NULL) {
        // Exit when EOF or error
        exit(0);
    }

    // trim spaces
    length = strlen(buf);
    for (start = 0; start < length; start += 1) {
        if (buf[start] > 0x20 && buf[start] < 0x7f) {
            break;
        }
    }
    for (end = length; end > start; end -= 1) {
        if (buf[end-1] > 0x20 && buf[end-1] < 0x7f) {
            break;
        }
    }
    length = end - start;
    for (int i = 0; i < length; i += 1) {
        buf[i] = buf[start + i];
    }
    buf[length] = 0;

    return buf;
}

// Prompt user input
char* prompt(const char* format, ...) {
    char* buf;
    // For information about this part, check
    // http://www.cplusplus.com/reference/cstdio/vprintf/
    va_list args;
    va_start (args, format);
    buf = vprompt (format, args);
    va_end (args);
    return buf;
}

// Prompt until valid
char* prompt_until_valid(int type, const char* format, ...) {
    va_list args;
    va_start (args, format);
    char* input = NULL;
    do
    {
        free(input);
        input = vprompt(format, args);
    } while (!is_valid(type, input));
    va_end (args);

    return input;
}

// Check whether an input is valid
BOOL is_valid(int type, const char* input) {
    BOOL valid = FALSE;
    switch (type)
    {
        case VT_MODE:
            valid = strcmp(input, "login") == 0 || strcmp(input, "signup") == 0;
    }

    if (!valid) {
        printf("Invalid input\n");
    }
    return valid;
}