package example1;

public interface Game {
	/* You cannot declare variables in an interface */
	/* We can declare constants in interfaces */
	public static final double BEST_FREQUENCY = 10.0;

	/*
	 * IMPORTANT: in an interface even if you dropped the final, 
	 * BEST_FREQUENCY will be a constant!. Very confusing. Do not 
	 * drop it.
	 * 
	 * If you declare the following variable in an interface it will 
	 * be a constant, even though looks like a variable. Don't do it. 
	 * Very confusing!
	 * 
	 * int x = 10;
	 */

	/* Methods a class is expected to implement */
	public void play();

	public int getScore();

	public void setPopularity(int value);
	
	public int getPopularity();

	/*
	 * We can declare default methods, but we will not use them in this class. As
	 * far as you are concern, interfaces are use to define the methods a class must
	 * implement.
	 */
	default boolean multiplayer() {
		return true;
	}
}
