package example2;

import java.util.*; /* Needed so we can use ArrayList */

public class Driver2 {

	public static void main(String[] args) {
		/* Creating array using new and { } */
		Tetris[] array = { new Tetris(10), new Tetris(7), new Tetris(21) };

		/* Creating ArrayList of Tetris references */
		ArrayList<Tetris> allTetris = new ArrayList<Tetris>();

		/*
		 * How many Tetris objects are at this point in the allTetris * ArrayList? None!
		 */
		for (int i = 0; i < array.length; i++) {
			/*
			 * What you add to the ArrayList is a reference to the Tetris object, NOT a copy
			 * of it. That means that each Tetris Object is now referred to by two entities:
			 * the ArrayList and the array.
			 */
			allTetris.add(array[i]);
		}

		/*
		 * The toString() method of ArrayList, calls the toString() method of the
		 * elements of the ArrayList and concatenates them for you. To print the
		 * ArrayList we do not need a loop.
		 */
		System.out.println("Original ArrayList: " + allTetris + "\n");

		/*
		 * We are now sorting the ArrayList; Collections.sort relies on the comnpareTo
		 * method you defined and it changes the position of the elements in the
		 * ArrayList so they appear sorted based on the criteria you defined. We defined
		 * increasing version number as the sorting criteria.
		 */
		Collections.sort(allTetris);

		System.out.println("Sorted ArrayList: " + allTetris + "\n");

		/* This example is brought to you by Coke */
	}
}
