package example3;

import java.util.*; /* Needed so we can use ArrayList */

public class Driver3 {

	public static void main(String[] args) {
		/* Both Tetris and Blackjack implement the Game interface */
		
		/* We can assign a Tetris or Blackjack reference to a Game reference */
		Game game = new Tetris(1);
		
		/* We can only execute methods that belong to a Game using game */
		game.setPopularity(100);
		System.out.println("Popularity: " + game.getPopularity());
		
	    /* Now assigning a Blackjack reference to game */
		game = new Blackjack(10);
		/* We can only execute methods that belong to a Game using game */
		System.out.println("Popularity: " + game.getPopularity());
		
		/* 
		 * game is a polymorphic reference variable; it can have the address 
		 * of many (poly) kinds of things (morphic).  In this example,
		 * any class that implements the Game interface can be assigned to game.
		 * What are the benefits of polymorphism?  We can define methods
		 * that can accept different, but related kinds of objects (see
		 * updatePopularity() method).  Also, we can group different, but
		 * related objects using an array of ArrayList (see printAllGames),
		 * array or any other collection.
		 */	
		
		Tetris tetris2 = new Tetris(10);
		Blackjack blackjack2 = new Blackjack(52);
		
		updatePopularity(tetris2, 100);
		updatePopularity(blackjack2, 50);
		
		System.out.println("Tetris2: " + tetris2);
		System.out.println("Blackjack2: " + blackjack2);
		
		/* Polymorphic ArrayList as it can stored different (but related)
		 * kinds of object.  They are related as all of them implement 
		 * the Game interface.
		 */
		ArrayList<Game> games = new ArrayList<Game>();
		games.add(tetris2);
		games.add(blackjack2);
		
		printAllGames(games);
	}
	
	/* 
	 * Notice the parameter is Game, but we can pass a Tetris or Blackjack reference
	 * 
	 */
	public static void updatePopularity(Game game, int newPopularity) {
		game.setPopularity(newPopularity);
	}
	
	public static void printAllGames(ArrayList<Game> allGames) {
		System.out.println("\nIn printAllGames:");
		
		for (int i = 0; i < allGames.size(); i++) {
			System.out.println(allGames.get(0));
		}
	}
}
