package example3;

import java.util.*; /* Needed so we can use ArrayList */

public class Driver4 {

	public static void main(String[] args) {
		Tetris tetris1 = new Tetris(10);
		Blackjack blackjack1 = new Blackjack(52);
		ArrayList<Game> games = new ArrayList<Game>();

		tetris1.setPopularity(100);
		blackjack1.setPopularity(50);

		games.add(tetris1);
		games.add(blackjack1);

		/*
		 * By using a polymorphic array or ArrayList we can combine different kind of
		 * objects and perform the same processing (call a common method) for all the
		 * objects in the collection (see displayPopularity).
		 */
		displayPopularity(games);

		/*
		 * What happens when you want to apply different kinds of processing to a
		 * collection? For example, you would like to rotate if the game is Tetris and
		 * increase cards if the game is Blackjack. You cannot do that with a Game
		 * reference, so you will need to cast the reference to a Tetris or Blackjack type.
		 * When you cast a reference you will treat the reference as if it is of the
		 * target cast type. For example, if game is a Game reference that is actually
		 * referring to a Tetris object, then casting game to a Tetris reference (Tetris t =
		 * (Tetris)game) is fine. Now we can call Tetris methods using t. However, if 
		 * game is pointing to something other than a Tetris object, you will get a 
		 * class cast exception! How can you tell which kind of object do you have? By using the
		 * instanceof operator. The instanceof tells you whether something belongs 
		 * to a class or interface (see instanceOfExample).
		 */
		instanceOfExample();

		/*
		 * Using instanceof and casting, we can call methods that are particular to a
		 * class by recognizing the kind of object we have.
		 */
		castingInstanceOfExample(games);
	}

	public static void displayPopularity(ArrayList<Game> allGames) {
		for (int i = 0; i < allGames.size(); i++) {
			/*
			 * Every object in ArrayList<Game> has a getPopularity() method as references in
			 * the ArrayList belong to classes that implement the Game interface.
			 */
			System.out.println(allGames.get(i).getPopularity());
		}
	}

	public static void instanceOfExample() {
		Tetris tetris1 = new Tetris(10);
		Blackjack blackjack1 = new Blackjack(52);

		Game game1 = tetris1, game2 = blackjack1;

		if (tetris1 instanceof Tetris) {
			System.out.println("tetris1 is an instance of Tetris");
		}

		if (blackjack1 instanceof Blackjack) {
			System.out.println("blackjack1 is an instance of Blackjack");
		}

		/*
		 * The next conditional does not compile; why? Because Java can tell that 
		 * a Tetris reference could never points to a Blackjack object. This is a 
		 * mistake.
		 */

		// if (tetris1 instanceof Blackjack) {
		// System.out.println("tetris1 is NOT an instance of Blackjack");
		// }

		/*
		 * Even though we assigned a Tetris reference to game1, Java is not smart enough
		 * to recognized it. So we need to wait until the code is executed for Java to
		 * actually check the kind of object game1 refers to, in order to determine
		 * whether is a Tetris object or not.
		 */
		if (game1 instanceof Tetris) {
			System.out.println("game1 refers to a Tetris object");
		}

		if (game1 instanceof Blackjack) {
			System.out.println("game1 refers to a Blackjack object");
		}

		if (game2 instanceof Blackjack) {
			System.out.println("game2 refers to a Blackjack object");
		}
	}

	public static void castingInstanceOfExample(ArrayList<Game> allGames) {
		for (int i = 0; i < allGames.size(); i++) {
			Game game = allGames.get(i);

			/* We can get the popularity for every game */
			System.out.println("Popularity: " + game.getPopularity());

			/*
			 * We can only call rotateOnce() if game is a Tetris object. game.rotateOnce() does
			 * not work as Tetris is a Game, but not every Game is necessarily a Tetris
			 * game. How can we tell that game refers to a Tetris object? By using instanceof
			 */
			if (game instanceof Tetris) {
				/*
				 * Casting: When we cast a reference to a particular type, we are 
				 * viewing the reference as if it is of the target type.  If we cast 
				 * a reference without checking whether the object associated with
				 * the reference is of the type associated with the cast, we will 
				 * get a class cast exception.
				 */

				/* Casting */
				Tetris tetris = (Tetris) game;

				/* Rotating */
				tetris.rotateOnce();
			}
		}
	}
}
