package example3;

/* We would like to sort an ArrayList of Tetris objects based on their
 * version number using Collections.sort(). Just defining a method
 * compareTo in this class is not enough as Collections.sort expects
 * an ArrayList of objects to belong to a class that implements
 * the Comparable interface.  Even if you define the method in this
 * class, Collections.sort will not see it, until you make the class
 * implement the interface.  Can a class implement more than one
 * interface?  Yes!  Just use commas to separate the interfaces.
 * The syntax to specify a class implements the compareTo method
 * is "implements Comparable<NAME_OF_CLASS_HERE>".  For the current
 * class that would be "implements Comparable<Tetris>".  Unlike
 * the equals method, the parameter for compareTo is always the
 * class name (e.g., compareTo(Tetris) in this case).
 */
public class Tetris implements Game, Comparable<Tetris> {
	private int rotationNumber, position = 1, popularity, version;

	public Tetris(int version) {
		this.version = version;
		rotationNumber = 0;
		popularity = 0;
	}

	public Tetris dropOnce() {
		position++;

		return this;
	}

	public Tetris rotateOnce() {
		rotationNumber++;

		return this;
	}

	public void play() {
		dropOnce().rotateOnce();
	}

	public int getScore() {
		return position * rotationNumber;
	}

	public void setPopularity(int value) {
		popularity = value;
	}

	public int getPopularity() {
		return popularity;
	}

	@Override
	public String toString() {
		return "Tetris [rotationNumber=" + rotationNumber + ", position=" + position + ", popularity=" + popularity
				+ ", version=" + version + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null)
			return false;
		if (obj.getClass() != getClass())
			return false;

		Tetris tetris = (Tetris) obj;

		return version == tetris.version;
	}

	/*
	 * Returns ANY negative value (not just -1) if when comparing the current object
	 * against the parameter, we would like the current object to appear first if we
	 * were to sort the current object and the parameter. Returns ANY positive value
	 * (not just 1) if when comparing the current object against the parameter, we
	 * would like the current object to appear after the parameter if we were to
	 * sort the current object and the parameter. 0 must be returned if we consider
	 * the current object and the parameter equal. It is recommended that the
	 * compareTo and equals method are in sync. That means that if the compareTo
	 * returns 0 for two objects, the equals method should return true for those two
	 * objects.
	 */
	public int compareTo(Tetris tetris) {
		/*
		 * Do not use a get method (e.g. getVersion()) to get the version of the
		 * parameter. A class can access the private instance variables/methods of an
		 * object that belongs to the same class. The current object and the parameter
		 * belong to the same class, so getVersion() is not necessary. Get methods are
		 * to be used by individuals that utilize the class (people that did not
		 * implement the class).
		 */
		if (version < tetris.version) {
			return -20; // Any negative value is fine
		} else if (version > tetris.version) {
			return 5;
		} else {
			return 0;
		}

		/*
		 * An equivalent code for the above cascaded if statement is return version -
		 * tetris.version;
		 */
	}
}
