package computerSys;

public class Mouse {
	private String brand;
	private int x, y;

	/* Allow us to create a Mouse object */
	public Mouse() {
	}

	public Mouse(String brand) {
		if (brand == null) {
			throw new IllegalArgumentException("You dropped the ball :)");
		}
		this.brand = brand;
		x = y = 0;
	}

	public String toString() {
		return brand + ", " + x + ", " + y;
	}

	public void changeCoordinates(int x, int y) {
		this.x = x;
		this.y = y;
	}

	public static Mouse referenceCopy(Mouse mouse) {
		return mouse;
	}

	public static Mouse deepCopy(Mouse mouse) {
		Mouse answer = new Mouse();

		answer.x = mouse.x;
		answer.y = mouse.y;
		answer.brand = new String(mouse.brand);

		return answer;
	}

	/* Between deep and shallow, shallow is */
	/* the most efficient in this case, */
	/* providing a copy that can be modified */
	/* without changing the original. */

	public static Mouse shallowCopy(Mouse mouse) {
		Mouse answer = new Mouse();

		answer.x = mouse.x;
		answer.y = mouse.y;
		answer.brand = mouse.brand;

		return answer;
	}
}
