package programs;

public class RecursionProblem {
	/*
	 * Specify which methods they can use: Character.toLowerCase,
	 * Character.toUpperCase, Character.toString()
	 */

	public static String replaceVowelsWith(String str, String replacement) {
		if (str == null || replacement == null) {
			throw new IllegalArgumentException("Invalid argument");
		}
		
		if (str.length() == 0) {
			return "";
		} else {
			char elem = Character.toLowerCase(str.charAt(0));
			if (elem == 'a' || elem == 'e' || elem == 'i' || elem == 'o' || elem == 'u') {
				return replacement + replaceVowelsWith(str.substring(1), replacement);
			} else {
				return Character.toString(elem) + replaceVowelsWith(str.substring(1), replacement);
			}
		}
	}

	public static int setToPositive(int[] array) {
		if (array == null) {
			throw new IllegalArgumentException("Invalid argument");
		}
		return setToPositive(array, 0);
	}

	private static int setToPositive(int[] array, int index) {
		if (index > array.length - 1) { /* Empty array segment */
			return 0;
		} else if (array[index] < 0) {
			array[index] *= -1;
			return 1 + setToPositive(array, index + 1);
		} else {
			return setToPositive(array, index + 1);
		}
	}
}
