package programs;

import java.util.ArrayList;

public class Train implements CargoVehicle, Comparable<Train> {
	private String name;
	private int numberOfTrainCars;
	private TrainCar[] allTrainCars;

	public Train(String name, int maxTrainCars) {
		this.name = name;
		numberOfTrainCars = 0;
		allTrainCars = new TrainCar[maxTrainCars];
	}

	public boolean addTrainCar() {
		if (numberOfTrainCars < allTrainCars.length) {
			allTrainCars[numberOfTrainCars++] = new TrainCar();

			return true;
		}
		return false;
	}

	public boolean addItemToCar(String itemsName, int tons, int trainCarIndex) {
		if (trainCarIndex < 0 || trainCarIndex >= numberOfTrainCars) {
			return false;
		}

		TrainCar trainCar = allTrainCars[trainCarIndex];
		try {
			trainCar.addItem(itemsName, tons);
			return true;
		} catch (IllegalArgumentException e) {
			System.err.println("Item not added");
			return false;
		}
	}

	/* Provided: Please do not modify */
	public String toString() {
		String answer = "";

		answer += "Name: " + name + "\n";
		answer += "NumberOfTrainCars: " + numberOfTrainCars + "\n";
		answer += "TrainCars:" + "\n";
		for (int i = 0; i < numberOfTrainCars; i++) {
			answer += allTrainCars[i] + "\n";
		}

		return answer;
	}

	/* Provided: Please do not modify */
	public String getName() {
		return name;
	}

	/* Provided: Please do not modify */
	public int getNumberOfTrainCars() {
		return numberOfTrainCars;
	}

	public int getTons() {
		int total = 0;

		for (int i = 0; i < numberOfTrainCars; i++) {
			total += allTrainCars[i].getTons();
		}

		return total;
	}

	public StringBuffer getItems() {
		StringBuffer answer = new StringBuffer();

		for (int i = 0; i < numberOfTrainCars; i++) {
			answer.append(allTrainCars[i].getItems());
		}

		return answer;
	}

	public int compareTo(Train train) {
		return train.getTons() - getTons();
	}

	public Train getTrainWithCars(String name, int[] trainCarIndices) {
		Train answer = new Train(name, trainCarIndices.length);
		int pos = 0;

		for (int index : trainCarIndices) {
			answer.allTrainCars[pos++] = new TrainCar(allTrainCars[index]);
		}
		answer.numberOfTrainCars = trainCarIndices.length;

		return answer;
	}

	public static int getNumberOfTrainCars(ArrayList<CargoVehicle> vehicles) {
		int total = 0;

		for (CargoVehicle vehicle : vehicles) {
			if (vehicle instanceof Train) {
				Train train = (Train) vehicle;
				total += train.getNumberOfTrainCars();
			}
		}

		return total;
	}
}