package programs;

import java.util.ArrayList;

public class TrainCar {
	private int tons;
	private ArrayList<String> trainCarItems;

	public TrainCar() {
		tons = 0;
		trainCarItems = new ArrayList<>();
	}

	public TrainCar(TrainCar trainCar) {
		this.tons = trainCar.tons;
		trainCarItems = new ArrayList<String>(trainCar.trainCarItems);
	}

	public TrainCar addItem(String itemsName, int tons) {
		if (itemsName == null || tons <= 0) {
			throw new IllegalArgumentException("Invalid argument");
		}

		this.tons += tons;
		trainCarItems.add(itemsName+tons);

		return this;
	}

	public String getItems() {
		return trainCarItems.toString();
	}

	public int getTons() {
		return tons;
	}

	/* Provided: Please do not modify */
	public String toString() {
		return "Tons: " + tons + ", Items: " + trainCarItems;
	}

	public boolean equals(Object obj) {
		if (obj == this)
			return true;
		if (obj == null || getClass() != obj.getClass())
			return false;
		TrainCar trainCar = (TrainCar) obj;

		return trainCarItems.toString().equals(trainCar.trainCarItems.toString());
	}
}