package programs;

public class Utilities {
	/* If more than one same length that is fine */
	public static int getLengthLargestRow(int[][] data) {
		if (data == null) {
			throw new IllegalArgumentException("Invalid argument");
		}

		int max = 0;
		for (int row = 0; row < data.length; row++) {
			if (data[row] != null) {
				if (data[row].length > max) {
					max = data[row].length;
				}
			}
		}

		return max;
	}

	public static int[] duplicateAndFill(int[] data, int newLength, int filler) {
		if (data == null || newLength < data.length) {
			throw new IllegalArgumentException("Invalid argument");
		}

		int answer[] = new int[newLength], i;
		for (i = 0; i < data.length; i++) {
			answer[i] = data[i];
		}
		for (; i < answer.length; i++) {
			answer[i] = filler;
		}

		return answer;
	}

	public static int[][] getNonRaggedArray(int[][] data, int filler) {
		if (data == null) {
			throw new IllegalArgumentException("Invalid argument");
		}

		int maxLength = getLengthLargestRow(data);
		int[][] answer = new int[data.length][];
		for (int row = 0; row < data.length; row++) {
			if (data[row] == null) {
				answer[row] = duplicateAndFill(new int[0], maxLength, filler);
			} else {
				answer[row] = duplicateAndFill(data[row], maxLength, filler);
			}
		}

		return answer;
	}
}
