package sysImplementation;

public class Refrigerator implements Appliance, Comparable<Refrigerator> {
	private String brand;
	private int bins;
	private StringBuffer items;
	private static final int DEFAULT_BINS_NUMBER = 10;

	// Total 13 tests
	// 1
	public Refrigerator(String brand, int bins) {
		this.brand = brand;
		this.bins = bins;
		items = new StringBuffer();
	}

	// 1
	public Refrigerator(String brand) {
		this(brand, DEFAULT_BINS_NUMBER);
	}

	// 1
	public Refrigerator(Refrigerator refrigerator) {
		brand = refrigerator.brand;
		bins = refrigerator.bins;
		items = new StringBuffer(refrigerator.items);
	}

	// 1
	public String getBrand() {
		return brand;
	}

	// 1
	public int getBins() {
		return bins;
	}

	// 3 test
	public Refrigerator addItem(String itemName) {
		if (itemName == null) {
			throw new IllegalArgumentException("Invalid");
		}

		items.append(itemName);

		return this;
	}

	// 2 test
	public boolean equals(Object obj) {
		if (obj == this) {
			return true;
		}
		if (obj == null || getClass() != obj.getClass()) {
			return false;
		}
		Refrigerator ref = (Refrigerator) obj;

		return brand.equals(ref.brand) && bins == ref.bins;
	}

	// 3 tests
	public int compareTo(Refrigerator refrigerator) {
		return bins - refrigerator.bins;
	}

	/*
	 * Do not modify this method, otherwise you will not pass release/secret tests
	 */
	public String toString() {
		return "Refrigerator [brand=" + brand + ", bins=" + bins + ", items=" + items + "]";
	}
}