package examples;

/* This class must implement the methods defined in */
/* the ElectricDevice interface.                    */
public class ElectricBus implements ElectricDevice {
	/* A static final is a constant that is shared by all objects */
	/* Remember how it will look in a memory map */
	private static final int MAX_PASSENGERS_PER_SEAT = 3;

	/* This is a non-static constant. Each object will have */
	/* its own constant. Compare this against a static one. */
	private final int voltage;

	private Seat[] seats;
	private int currentSeats;

	public ElectricBus(int maxSeats, int voltage) {
		/* After we initialize the voltage instance variable */
		/* it cannot be changed as we defined as constant */
		this.voltage = voltage;

		/* How many seat objects do we have after the next declaration? */
		seats = new Seat[maxSeats];
	}

	public void addSeat(String color) {
		if (currentSeats < seats.length) { /* If we have space */
			/* The current number of seats represents where the next */
			/* seat should be added */
			if (seats[currentSeats] != null) {
				System.out.println("Warning, overwriting existing seat");
				seats[currentSeats] = new Seat(MAX_PASSENGERS_PER_SEAT, color);
			} else {
				seats[currentSeats] = new Seat(MAX_PASSENGERS_PER_SEAT, color);
				currentSeats++;
			}
		}
	}

	public void removeSeat(int index) {
		/* Notice this can create empty gaps between seats */
		if (seats[index] != null) {
			currentSeats--;
			seats[index] = null;
		}
	}

	/* Returns an array with copies of seats (if parameter is true) */
	/* The array has exactly the seats in the ElectricBus */
	public Seat[] getSeats(boolean copySeats) {
		Seat[] answer = new Seat[this.currentSeats];

		for (int i = 0, k = 0; i < seats.length; i++) {
			if (seats[i] != null) {
				/* Notice the use of the ternary operator ? : */
				answer[k++] = (copySeats ? new Seat(seats[i]) : seats[i]);
			}
		}

		return answer;
	}

	public int getVoltage() {
		return voltage;
	}

	public void checkCurrentSource(int source) {
		if (source > voltage) {
			System.out.println("Problem");
		} else {
			System.out.println("System OK");
		}
	}

	public String toString() {
		String answer = "";

		answer += "Voltage: " + voltage;
		answer += "\nCurrentSeats: " + currentSeats;
		answer += "\nSeats:\n";

		/* Notice we are printing the whole array */
		for (int i = 0; i < seats.length; i++) {
			answer += seats[i] + "\n";
		}

		return answer;
	}
}
