package examples;

/* By this class implementing the Comparable interface */
/* it needs to provide a compareTo method.  By implementing */
/* this interface, we can sort Seats in an ArrayList by */
/* using the Collections.sort method. */
/* This space available for rent */

public class Seat implements Comparable<Seat> {
	private int maxPassengers, currentPassengers;
	private String color;

	public Seat(int maxPassengers, String color) {
		this.maxPassengers = maxPassengers;
		
		/* We don't need to set currentPassengers to 0 as it is */
		/* the default value, but setting it to 0 makes your code */
		/* clearer. */
		this.currentPassengers = 0;
		this.color = color;
	}

	/* This copy constructor makes a deep copy; do we really need */
	/* a deep copy. */
	public Seat(Seat seat) {
		this.maxPassengers = seat.maxPassengers;
		this.currentPassengers = seat.currentPassengers;
		this.color = new String(seat.color);
	}
	
	/* Should we have getters and setters? */
	/* We should always try to make classes immutable. */
	/* For this problem, we don't need to make it mutable */

	public int getMaxPassengers() {
		return maxPassengers;
	}

	public int getCurrentPassengers() {
		return currentPassengers;
	}

	/* This method returns a reference to the current object */
	/* This will allow us to chain a set of addPassenger() calls */
	/* For example, assume s is a set reference, we can then: */
	/* s.addPassenger().addPassenger() */
	/* Notice that this can never be null as it always refers */
	/* to the current object (the object the method is operating on */
	public Seat addPassenger() {
		if (currentPassengers < maxPassengers) {
			currentPassengers++;
		}

		return this;
	}

	public String getColor() {
		return color;
	}

	/* The parameter to compareTo is a Seat reference, not an Object one */
	public int compareTo(Seat seat) {
		return currentPassengers - seat.currentPassengers;
	}

	public String toString() {
		return "Seat [maxPassengers=" + maxPassengers + ", currentPassengers=" + currentPassengers + ", color=" + color
				+ "]";
	}
}
