#lang racket
(require "../translate.rkt")
(require "../parse.rkt")
(require "../ast.rkt")
(require rackunit)
(check-equal? (translate (parse '(let ((x 0)) x)))
              (Let '_ (Int 0) (Var 0)))
(check-equal? (translate (parse '(let ((x 0)) (let ((y 1)) x))))
              (Let '_ (Int 0) (Let '_ (Int 1) (Var 1))))
(check-equal? (translate (parse '(let ((x 0)) (let ((y 1)) y))))
              (Let '_ (Int 0) (Let '_ (Int 1) (Var 0))))
(check-equal? (translate (parse '(let ((x 0))
                            (let ((y x))
                              y))))
              (Let '_ (Int 0) (Let '_ (Var 0) (Var 0))))
