package FileIOExamples;

import java.io.*;
import java.net.*;
import java.util.Scanner;

/*
 * Reading online data is similar to reading from a file.
 */
public class ReadingOnlineData {
	public static void main(String[] args) {
		String filename = "http://www.cs.umd.edu/~nelson/classes/utilities/cmsc131/data.txt";
		Scanner scanner;

		System.out.println("Reading information from file " + filename);
		try {
			/*
			 * We can use Scanner and URL to open a text file available online. 
			 * We need to handle the IOException associated with using File
			 */
			scanner = new Scanner((new URL(filename)).openConnection().getInputStream());

			/* From this point on you use scanner as usual */
			while (scanner.hasNext()) {
				String name = scanner.next();
				int age = scanner.nextInt();
				System.out.println("Name: " + name + ", Age: " + age);
			}
		} catch (IOException e) {
			/* Using System.err */
			System.err.println(e.getMessage());
		}
	}
}