import java.util.PriorityQueue;

public class ERQueue {

    // NOTE: Patient is declared static ONLY for convenience in this demo.
    // It has nothing to do with PriorityQueue behavior.
    // In a real project, Patient would likely be a top-level class in its own file.
    static class Patient implements Comparable<Patient> {
        String name;
        int urgency;  // Lower = more urgent

        public Patient(String name, int urgency) {
            this.name = name;
            this.urgency = urgency;
        }

        // Defines the natural ordering: more urgent patients come first
        @Override
        public int compareTo(Patient other) {
            return Integer.compare(this.urgency, other.urgency);
        }

        @Override
        public String toString() {
            return name + " (urgency: " + urgency + ")";
        }
    }

    public static void main(String[] args) {
        // PriorityQueue uses the compareTo method from Patient class
        PriorityQueue<Patient> erQueue = new PriorityQueue<>();

        // Add patients with various urgency levels
        erQueue.add(new Patient("Alice", 2));
        erQueue.add(new Patient("Bob", 5));
        erQueue.add(new Patient("Charlie", 1));
        erQueue.add(new Patient("Diana", 3));

        System.out.println("Patients in treatment order:");
        while (!erQueue.isEmpty()) {
            System.out.println("→ " + erQueue.poll());
        }
    }
}

