import java.util.PriorityQueue;
import java.util.Comparator;

public class MaxHeapDemo {
    public static void main(String[] args) {
        // Create a PriorityQueue using a custom comparator that reverses the natural order.
        // For Strings, natural order means alphabetical (A → Z), so reverse order becomes Z → A.
        //
        // Comparator.reverseOrder() is a built-in Java method that returns a Comparator
        // which imposes the reverse of the natural ordering.
        //
        // Equivalent to:
        // Comparator<String> reverse = (a, b) -> b.compareTo(a);
    	//
    	// Reverses the natural order to create a max-heap.
    	// If 'a' is originally smaller than 'b', then b.compareTo(a) returns > 0.
    	// So: compare("a", "b") → positive → heap thinks 'a' is larger.
    	// BUT since PriorityQueue always puts the "smallest" (based on comparator) at the top,
    	// this reversal tricks the heap into putting the largest element first → max-heap behavior.
        //
        // This turns the default min-heap into a max-heap.
        PriorityQueue<String> states = new PriorityQueue<>(Comparator.reverseOrder());

        // Add six U.S. state names to the queue
        states.add("Alaska");
        states.add("Georgia");
        states.add("Ohio");
        states.add("Wisconsin");
        states.add("Nevada");
        states.add("Arizona");

        // Print out the raw queue structure (heap, not sorted)
        System.out.println("Queue contents (heap-structured): " + states);

        // Peek at the head of the queue — this is the alphabetically last state (max)
        System.out.println("Peek (head of max-heap): " + states.peek());  // Expected: "Wisconsin"

        // Remove and return the head of the queue
        System.out.println("Poll (remove head): " + states.poll());      // Removes "Wisconsin"

        // Peek again to see the new head after one removal
        System.out.println("Peek after poll: " + states.peek());         // Expected: "Ohio"

        // Remove a specific element (not necessarily the head)
        boolean removed = states.remove("Alaska");
        System.out.println("Removed 'Alaska'? " + removed);              // Expected: true

        // Check current size
        System.out.println("Current size: " + states.size());

        // Iterate through the remaining elements (heap order, not sorted)
        System.out.println("Remaining elements (unsorted):");
        for (String state : states) {
            System.out.println(state);
        }

        // Clear the queue
        states.clear();
        System.out.println("Is queue empty after clear? " + states.isEmpty());   // true
    }
}

