import java.util.PriorityQueue;

public class PriorityQueueDemo {
    public static void main(String[] args) {
        // Create a PriorityQueue of Strings (min-heap based on natural ordering)
        PriorityQueue<String> states = new PriorityQueue<>();

        // Add elements to the queue
        states.add("Texas");         // add() inserts an element
        states.add("California");
        states.add("Delaware");
        states.offer("Florida");     // offer() is similar to add(), returns false if it fails (rare for PQ)

        // Display the contents using toString (NOTE: order is NOT sorted!)
        System.out.println("Queue contents (not sorted): " + states);

        // Peek at the element with the highest priority (alphabetically first)
        System.out.println("Peek (head of queue): " + states.peek());  // Expected: "California"

        // Remove the head element (alphabetically first)
        System.out.println("Poll (remove head): " + states.poll());    // Removes "California"

        // Peek again after removal
        System.out.println("Peek after poll: " + states.peek());       // Expected: "Delaware"

        // Remove a specific object (not necessarily the head)
        boolean removed = states.remove("Texas");                      // Removes "Texas" if it exists
        System.out.println("Removed 'Texas'? " + removed);

        // Try removing an element that doesn't exist
        boolean removedFake = states.remove("Nevada");
        System.out.println("Removed 'Nevada'? " + removedFake);        // Expected: false

        // Size of the queue
        System.out.println("Size of queue: " + states.size());

        // Check if an element exists
        System.out.println("Contains 'Florida'? " + states.contains("Florida")); // true
        System.out.println("Contains 'Texas'? " + states.contains("Texas"));     // false

        // Iterate through elements (not sorted order)
        System.out.println("Iterating through remaining elements:");
        for (String state : states) {
            System.out.println(state);
        }

        // Clear the queue
        states.clear();
        System.out.println("Is queue empty after clear? " + states.isEmpty());   // true
    }
}

