import java.util.PriorityQueue;
import java.util.Comparator;

public class TaskManager {
    
    // Define a Task class with description and priority
    static class Task {
        String description;
        int priority;  // smaller number = higher priority (e.g., 1 is more urgent than 5)

        public Task(String description, int priority) {
            this.description = description;
            this.priority = priority;
        }

        @Override
        public String toString() {
            return "[" + description + " (priority: " + priority + ")]";
        }
    }

    public static void main(String[] args) {
        // Comparator that compares tasks by their priority field
        // Lower priority value means higher priority in execution
        Comparator<Task> byPriority = new Comparator<>() {
            @Override
            public int compare(Task t1, Task t2) {
                // If t1.priority < t2.priority, t1 is higher priority → should come first
                return Integer.compare(t1.priority, t2.priority);
            }
        };

        // Create a PriorityQueue of Tasks, ordered by priority (min-heap style)
        PriorityQueue<Task> taskQueue = new PriorityQueue<>(byPriority);

        // Add some tasks to the queue
        taskQueue.add(new Task("Fix security bug", 1));         // Highest priority
        taskQueue.add(new Task("Reply to emails", 5));          // Low priority
        taskQueue.add(new Task("Prepare presentation", 3));     // Medium priority
        taskQueue.add(new Task("Update documentation", 4));     // Low-medium priority
        taskQueue.add(new Task("Code review", 2));              // High priority

        // Print tasks in the order they will be processed
        System.out.println("Tasks in execution order:");
        while (!taskQueue.isEmpty()) {
            Task next = taskQueue.poll();  // Removes and returns the task with the highest priority (lowest number)
            System.out.println("→ " + next);
        }
    }
}
