import java.util.HashSet;
import java.util.TreeSet;
import java.util.Set;

public class LinkedList<T extends Comparable<T>> {
    private class Node {
        private T data;
        private Node next;

        private Node(T data) {
            this.data = data;
            this.next = null;
        }
    }

    private Node head;

    public LinkedList() {
        head = null;
    }

    /**
     * Removes elements from the linked list that fall within the range defined by lowerBound and upperBound.
     * The elements that are removed will be placed in a set.
     * 
     * If the ordered parameter is true, the returned set will be in natural order
     * that were removed from the list. Otherwise, an unordered but efficient set will be returned.
     *
     * @param ordered If true, the set will retain the natural order, otherwise it will not.
     * @param lowerBound The lower bound value of the range (inclusive).
     * @param upperBound The upper bound value of the range (inclusive).
     * @return A set containing the elements that were removed from the list.
     */
    public Set<T> removeInRange(boolean ordered, T lowerBound, T upperBound) {
        // You must implement this method

        return null; // Placeholder return statement. Remove this once implemented.
    }

    /**
     * Recursively removes elements from the linked list that are in the range defined by lowerBound and upperBound.
     * The removed elements will be placed in the provided set.
     * 
     * This method should traverse the list starting from the head, process each element, and modify the list
     * as it goes by removing the nodes that fall within the specified range.
     * 
     * @param headAux The current node being processed in the list.
     * @param lowerBound The lower bound value of the range (inclusive).
     * @param upperBound The upper bound value of the range (inclusive).
     * @param newSet The set where removed elements will be added.
     * @return The updated list after removal of nodes in the range.
     */
    private Node removeInRangeAux(Node headAux, T lowerBound, T upperBound, Set<T> newSet) {
        // You must implement this method

        return null; // Placeholder return statement. Remove this once implemented.
    }

    public static void main(String[] args) {
        // Driver to test the LinkedList with lizard names

        LinkedList<String> list = new LinkedList<>();

        // Add lizard names to the list
        list.add("Iguana");
        list.add("Chameleon");
        list.add("Gecko");
        list.add("Anole");
        list.add("Komodo Dragon");
        list.add("Bearded Dragon");
        list.add("Skink");
        list.add("Monitor Lizard");
        list.add("Agama");
        list.add("Gila Monster");
        list.add("Horned Lizard");
        list.add("Frilled Lizard");
        list.add("Leopard Gecko");
        list.add("Tokay Gecko");
        list.add("Water Dragon");

        // Print original list
        System.out.println("Original list: ");
        list.printList();

        // Remove elements within the range "Horned Lizard" to "Skink" and keep insertion order
        Set<String> removedOrdered = list.removeInRange(true, "Horned Lizard", "Skink");

        System.out.println("\nRemoved (Ordered): " + removedOrdered);
        list.printList();
        
        list = new LinkedList<>();  //reset the list

        // Add lizard names to the list
        list.add("Iguana");
        list.add("Chameleon");
        list.add("Gecko");
        list.add("Anole");
        list.add("Komodo Dragon");
        list.add("Bearded Dragon");
        list.add("Skink");
        list.add("Monitor Lizard");
        list.add("Agama");
        list.add("Gila Monster");
        list.add("Horned Lizard");
        list.add("Frilled Lizard");
        list.add("Leopard Gecko");
        list.add("Tokay Gecko");
        list.add("Water Dragon");

        // Remove elements within the range "Horned Lizard" to "Skink" and do not keep insertion order
        Set<String> removedUnordered = list.removeInRange(false, "Horned Lizard", "Skink");

        System.out.println("\nRemoved (Unordered): " + removedUnordered);
        list.printList();
    }

    // Method to add elements to the list for testing
    private void add(T data) {
        Node newNode = new Node(data);
        if (head == null) {
            head = newNode;
        } else {
            Node current = head;
            while (current.next != null) {
                current = current.next;
            }
            current.next = newNode;
        }
    }

    // Method to print the list for testing
    private void printList() {
        Node current = head;
        while (current != null) {
            System.out.print(current.data + " -> ");
            current = current.next;
        }
        System.out.println("null");
    }
}

