package tv;

public class ConventionalTV extends TV {
	private static final String DEFAULT_CATHODE_RAY_TUBE = "A";
	private String cathodeRayTubeType;
	
	public ConventionalTV() {
		super(20, "GEConv");
		cathodeRayTubeType = DEFAULT_CATHODE_RAY_TUBE;
	}
	
	public ConventionalTV(String cathodeRayTubeType) {
		super(30, "GEConvSpec");
		this.cathodeRayTubeType =  cathodeRayTubeType;
	}
	
	public ConventionalTV(int diagonalLength, String brand, 
			String cathodeRayTubeType) {
		super(diagonalLength, brand);
		this.cathodeRayTubeType = cathodeRayTubeType;
	}
	
	public String toString() {
		return super.toString() + ", Cathode Ray Tube Type: " + cathodeRayTubeType;
	}
	
	public static void main(String[] args) {
		ConventionalTV tvSet1= new ConventionalTV();
		ConventionalTV tvSet2 = new ConventionalTV(32, "GE", "B");
		
		System.out.println(tvSet1);
		System.out.println(tvSet2);
	}
}
