package tv;

public class HighDefTV extends TV {
	private static String DIGITAL_CONVERTER = "1280DPI";
	private String digitalConverter;

	public HighDefTV() {
		super(); // We don't need it. Why???
		digitalConverter = DIGITAL_CONVERTER;
	}

	/* Calls super class constructor by using super */
	public HighDefTV(int diagonalLength, String brand, String digitalConverter) {
		super(diagonalLength, brand);
		this.digitalConverter = digitalConverter;
	}

	public String getDigitalConverter() {
		return digitalConverter;
	}

	/* overrides toString and calls the toString method of the superclass */
	public String toString() {
		return super.toString() + ", Digital Converter: " + digitalConverter;
	}

	/* overloads toString and uses the other toString() to generate result */
	public String toString(int indentation) {
		String result = "";

		for (int i = 0; i < indentation; i++) {
			result += " ";
		}

		result += toString();
		return result;
	}

	public void setDigitalConverter(String digitalConverter) {
		this.digitalConverter = digitalConverter;
	}

	public static void main(String[] args) {
		HighDefTV tvSet1 = new HighDefTV();
		
		System.out.println(tvSet1);

		HighDefTV tvSet2 = new HighDefTV(50, "GE", "4500DPI");
		System.out.println(tvSet2);

		/* Which toString will be called */
		TV temp = tvSet2;
		System.out.println(temp);

		/* Calling the overloaded toString method */
		System.out.println(tvSet2.toString(10));

		tvSet2.changeChannel(24);
		System.out.println(tvSet2);
	}
}