#lang racket
(require rackunit
         (rename-in "../stdlib.rkt" [read read-stdin]))

(define (p s)
  (with-input-from-string s
    (lambda ()
      (read-stdin))))

(check-equal? (p "") eof)
(check-equal? (p "  ") eof)
(check-equal? (p ";123") eof)
(check-equal? (p "#;123 ") eof)
(check-equal? (p "#;123") eof)
(check-equal? (p "#|123|# ") eof)
(check-equal? (p "#;#|123|#1 ") eof)
(check-equal? (p "#;#;1 2") eof)
(check-equal? (p "123") 123)
(check-equal? (p "#t") #t)
(check-equal? (p "#f") #f)
(check-equal? (p "#T") #t)
(check-equal? (p "#F") #f)
(check-equal? (p "#b0") 0)
(check-equal? (p "#b1") 1)
(check-equal? (p "#b101") #b101)
(check-equal? (p "#B101") #b101)
(check-equal? (p "#o0") 0)
(check-equal? (p "#o1") 1)
(check-equal? (p "#o701") #o701)
(check-equal? (p "#O701") #o701)
(check-equal? (p "#d0") 0)
(check-equal? (p "#d1") 1)
(check-equal? (p "#d901") 901)
(check-equal? (p "#D901") 901)
(check-equal? (p "#x0") 0)
(check-equal? (p "#x1") 1)
(check-equal? (p "#xF01") #xF01)
(check-equal? (p "#XF01") #xF01)
(check-equal? (p ";123\n1") 1)
(check-equal? (p "()") '())
(check-equal? (p "[]") '())
(check-equal? (p "{}") '())
(check-equal? (p "(#t)") '(#t))
(check-equal? (p "[#t]") '(#t))
(check-equal? (p "{#t}") '(#t))
(check-equal? (p "((#t))") '((#t)))
(check-equal? (p "#\\u ") #\u)
(check-equal? (p "#\\p\n") #\p)
(check-equal? (p "(1 . 2)") '(1 . 2))
#|
(check-pred err? (p (string-append "#" "|")))
(check-pred err? (p "#;")) 
(check-pred err? (p "(}"))
(check-pred err? (p "(]"))
(check-pred err? (p "[)"))
(check-pred err? (p "(x}"))
(check-pred err? (p "(x]"))
(check-pred err? (p "[x)"))
(check-pred err? (p "(x . y}"))
(check-pred err? (p "(x . y]"))
(check-pred err? (p "[x . y)")))
|#
