function clusterradius = computeradius(asdata,centers,aclus);
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% clusterradius = computeradius(asdata,centers,aclus)    %
%  Compute the cluster radii for data asdata relative to %
%  clustercenters centers and cluster assignments aclus. %
% asdata = mxpxq array of values                         %
% centers = qxk array of initial guesses at centers      %
%           of the k clusters                            %
% aclus = mxp array of the cluster number for            %
%         each value                                     %
%  DPO 04/03                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[m,p,q] = size(asdata);
[q,k] = size(centers);
clusterradius = zeros(1,k);

for i=1:m,
  for j=1:p,
     ind = aclus(i,j);
     d = norm(reshape(asdata(i,j,:),q,1)-centers(:,ind));
     if (d > clusterradius(ind))
        clusterradius(ind) = d;
     end % if
  end  % for j
end  % for i

