function [aclus,clustercounts] = map_to_cluster(asdata,centers)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [aclus,clustercounts] =  ...                  %
%                map_to_cluster(asdata,centers)          %
% Input:                                                 %
% asdata = mxpxq array of values                         %
% centers = qxk array of initial guesses at centers      %
%           of the k clusters                            %
% Output:                                                %
% aclus = mxp array of the cluster number for            %
%         each value                                     %
% clustercounts = 1xk array of number of points in each  %
%                 of the  k  clusters                    %
% DPO 03/03                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize m,p,q,k,clustercounts.                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[m,p,q] = size(asdata);
[q,k] = size(centers);
clustercounts = zeros(1,k);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Assign each point to a cluster and count the number    %
% in each cluster.                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for i=1:m,
for j=1:p,
 temp = reshape(asdata(i,j,:),q,1);
 for kk = 1:k,
   d(kk) = norm(temp-centers(:,kk));
 end
 [mindist,alist] = min(d);
 aclus(i,j) = alist(1); % Ties broken here if necessary.
 clustercounts(aclus(i,j)) = clustercounts(aclus(i,j)) + 1;
end
end

