function z = axquad(xpts,h,xend)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = axquad(xpts,h,xend)
% This function computes the values of a psi_i' psi_i' + c psi_i psi_i
% at the points specified by xpts,
% where psi is a quadratic basis element for the finite element method.
% It is used by quad in computing matrix entries for the finite element
% formulations.
%
% Input:
%  xpts is a row or column vector of points
%  h is the distance between mesh points 
%  xend is an endpoint of the interval over which the basis function
%    is nonzero.
%
% Functions required: a, c
% Outputs:
%  z =  a(xpts) psi'_i(xpts) psi'_i(xpts) 
%        + c(xpts) psi_i(xpts)  psi_i(xpts)    
%
% axquad.m      Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

psi      = -4*(xpts-xend).*(xpts-(xend+h))/h^2;
psiprime = -4*(2*xpts-2*xend-h)/h^2;

z = a(xpts).*(psiprime.^2) + c(xpts).*(psi.^2);
