function z = f(x)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = f(x)
% This function  computes the function f(x)
% for the differential equation
%   -(a(x) u'(x))' + c(x) u(x) = f(x)  for x in (0,1)
% with u(0)=u(1)=0.
%
% The values are computed by calls to functions a and c,
% to obtain the coefficient functions, and trueu, to
% obtain values of the true solution u.
%
% Input:
%  x is a row or column vector of points
%
% Outputs:
%  z =  f(x)
%
% f.m     Dianne P. O'Leary   January 2005
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[a0,ap] = a(x);         % to compute a(x) and a'(x)

[u,up,upp] = trueu(x);  % to compute u(x), u'(x), and u''(x)

z = -(a0.*upp + ap.*up) + c(x).*u;
